/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.bulk;

import co.elastic.clients.elasticsearch._core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch._core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch._core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch._core.bulk.OperationVariant;
import co.elastic.clients.elasticsearch._core.bulk.UpdateOperation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Operation
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String INDEX = "index";
    public static final String CREATE = "create";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Operation> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Operation::setupOperationDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Operation(OperationVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Operation(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Operation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public IndexOperation index() {
        return (IndexOperation)TaggedUnionUtils.get(this, INDEX);
    }

    public CreateOperation create() {
        return (CreateOperation)TaggedUnionUtils.get(this, CREATE);
    }

    public UpdateOperation update() {
        return (UpdateOperation)TaggedUnionUtils.get(this, UPDATE);
    }

    public DeleteOperation delete() {
        return (DeleteOperation)TaggedUnionUtils.get(this, DELETE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupOperationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, IndexOperation._DESERIALIZER, INDEX, new String[0]);
        op.add(Builder::create, CreateOperation._DESERIALIZER, CREATE, new String[0]);
        op.add(Builder::update, UpdateOperation._DESERIALIZER, UPDATE, new String[0]);
        op.add(Builder::delete, DeleteOperation._DESERIALIZER, DELETE, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Operation> {
        private String _type;
        private Object _value;

        public Builder index(IndexOperation v) {
            this._type = Operation.INDEX;
            this._value = v;
            return this;
        }

        public Builder index(Function<IndexOperation.Builder, ObjectBuilder<IndexOperation>> f) {
            return this.index(f.apply(new IndexOperation.Builder()).build());
        }

        public Builder create(CreateOperation v) {
            this._type = Operation.CREATE;
            this._value = v;
            return this;
        }

        public Builder create(Function<CreateOperation.Builder, ObjectBuilder<CreateOperation>> f) {
            return this.create(f.apply(new CreateOperation.Builder()).build());
        }

        public Builder update(UpdateOperation v) {
            this._type = Operation.UPDATE;
            this._value = v;
            return this;
        }

        public Builder update(Function<UpdateOperation.Builder, ObjectBuilder<UpdateOperation>> f) {
            return this.update(f.apply(new UpdateOperation.Builder()).build());
        }

        public Builder delete(DeleteOperation v) {
            this._type = Operation.DELETE;
            this._value = v;
            return this;
        }

        public Builder delete(Function<DeleteOperation.Builder, ObjectBuilder<DeleteOperation>> f) {
            return this.delete(f.apply(new DeleteOperation.Builder()).build());
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}

