/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.FieldAndFormat;
import co.elastic.clients.elasticsearch._core.search.FieldCollapse;
import co.elastic.clients.elasticsearch._core.search.Highlight;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InnerHits
implements JsonpSerializable {
    @Nullable
    private final String name;
    @Nullable
    private final Integer size;
    @Nullable
    private final Integer from;
    @Nullable
    private final FieldCollapse collapse;
    @Nullable
    private final List<FieldAndFormat> docvalueFields;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Highlight highlight;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final List<JsonValue> sort;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> storedField;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final Boolean version;
    public static final JsonpDeserializer<InnerHits> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InnerHits::setupInnerHitsDeserializer, Builder::build);

    public InnerHits(Builder builder) {
        this.name = builder.name;
        this.size = builder.size;
        this.from = builder.from;
        this.collapse = builder.collapse;
        this.docvalueFields = ModelTypeHelper.unmodifiable(builder.docvalueFields);
        this.explain = builder.explain;
        this.highlight = builder.highlight;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.scriptFields = ModelTypeHelper.unmodifiable(builder.scriptFields);
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.storedField = ModelTypeHelper.unmodifiable(builder.storedField);
        this.trackScores = builder.trackScores;
        this.version = builder.version;
    }

    public InnerHits(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public FieldCollapse collapse() {
        return this.collapse;
    }

    @Nullable
    public List<FieldAndFormat> docvalueFields() {
        return this.docvalueFields;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public Highlight highlight() {
        return this.highlight;
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> storedField() {
        return this.storedField;
    }

    @Nullable
    public Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public Boolean version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
        if (this.docvalueFields != null) {
            generator.writeKey("docvalue_fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.docvalueFields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.scriptFields != null) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.seqNoPrimaryTerm != null) {
            generator.writeKey("seq_no_primary_term");
            generator.write(this.seqNoPrimaryTerm.booleanValue());
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            generator.write(this.source);
        }
        if (this.storedField != null) {
            generator.writeKey("stored_field");
            generator.writeStartArray();
            for (String string : this.storedField) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.booleanValue());
        }
    }

    protected static void setupInnerHitsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from", new String[0]);
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse", new String[0]);
        op.add(Builder::docvalueFields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "docvalue_fields", new String[0]);
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain", new String[0]);
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight", new String[0]);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields", new String[0]);
        op.add(Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::storedField, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_field", new String[0]);
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores", new String[0]);
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InnerHits> {
        @Nullable
        private String name;
        @Nullable
        private Integer size;
        @Nullable
        private Integer from;
        @Nullable
        private FieldCollapse collapse;
        @Nullable
        private List<FieldAndFormat> docvalueFields;
        @Nullable
        private Boolean explain;
        @Nullable
        private Highlight highlight;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Boolean seqNoPrimaryTerm;
        @Nullable
        private List<String> fields;
        @Nullable
        private List<JsonValue> sort;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> storedField;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private Boolean version;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        public Builder docvalueFields(@Nullable List<FieldAndFormat> value) {
            this.docvalueFields = value;
            return this;
        }

        public Builder docvalueFields(FieldAndFormat ... value) {
            this.docvalueFields = Arrays.asList(value);
            return this;
        }

        public Builder addDocvalueFields(FieldAndFormat value) {
            if (this.docvalueFields == null) {
                this.docvalueFields = new ArrayList<FieldAndFormat>();
            }
            this.docvalueFields.add(value);
            return this;
        }

        public Builder docvalueFields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.docvalueFields(fn.apply(new FieldAndFormat.Builder()).build());
        }

        public Builder addDocvalueFields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.addDocvalueFields(fn.apply(new FieldAndFormat.Builder()).build());
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public Builder scriptFields(@Nullable Map<String, ScriptField> value) {
            this.scriptFields = value;
            return this;
        }

        public Builder putScriptFields(String key, ScriptField value) {
            if (this.scriptFields == null) {
                this.scriptFields = new HashMap<String, ScriptField>();
            }
            this.scriptFields.put(key, value);
            return this;
        }

        public Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(Collections.singletonMap(key, fn.apply(new ScriptField.Builder()).build()));
        }

        public Builder putScriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.putScriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder storedField(@Nullable List<String> value) {
            this.storedField = value;
            return this;
        }

        public Builder storedField(String ... value) {
            this.storedField = Arrays.asList(value);
            return this;
        }

        public Builder addStoredField(String value) {
            if (this.storedField == null) {
                this.storedField = new ArrayList<String>();
            }
            this.storedField.add(value);
            return this;
        }

        public Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        @Override
        public InnerHits build() {
            return new InnerHits(this);
        }
    }
}

