/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeAttributes
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final String ephemeralId;
    @Nullable
    private final String id;
    private final String name;
    private final String transportAddress;
    @Nullable
    private final List<NodeRole> roles;
    public static final JsonpDeserializer<NodeAttributes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAttributes::setupNodeAttributesDeserializer, Builder::build);

    public NodeAttributes(Builder builder) {
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
        this.ephemeralId = Objects.requireNonNull(builder.ephemeralId, "ephemeral_id");
        this.id = builder.id;
        this.name = Objects.requireNonNull(builder.name, "name");
        this.transportAddress = Objects.requireNonNull(builder.transportAddress, "transport_address");
        this.roles = ModelTypeHelper.unmodifiable(builder.roles);
    }

    public NodeAttributes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String ephemeralId() {
        return this.ephemeralId;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    @Nullable
    public List<NodeRole> roles() {
        return this.roles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("ephemeral_id");
        generator.write(this.ephemeralId);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        if (this.roles != null) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodeAttributesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeAttributes> {
        private Map<String, String> attributes;
        private String ephemeralId;
        @Nullable
        private String id;
        private String name;
        private String transportAddress;
        @Nullable
        private List<NodeRole> roles;

        public Builder attributes(Map<String, String> value) {
            this.attributes = value;
            return this;
        }

        public Builder putAttributes(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder ephemeralId(String value) {
            this.ephemeralId = value;
            return this;
        }

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public Builder roles(@Nullable List<NodeRole> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(NodeRole ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(NodeRole value) {
            if (this.roles == null) {
                this.roles = new ArrayList<NodeRole>();
            }
            this.roles.add(value);
            return this;
        }

        @Override
        public NodeAttributes build() {
            return new NodeAttributes(this);
        }
    }
}

