/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RefreshStats
implements JsonpSerializable {
    private final long externalTotal;
    private final long externalTotalTimeInMillis;
    private final long listeners;
    private final long total;
    @Nullable
    private final String totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<RefreshStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RefreshStats::setupRefreshStatsDeserializer, Builder::build);

    public RefreshStats(Builder builder) {
        this.externalTotal = Objects.requireNonNull(builder.externalTotal, "external_total");
        this.externalTotalTimeInMillis = Objects.requireNonNull(builder.externalTotalTimeInMillis, "external_total_time_in_millis");
        this.listeners = Objects.requireNonNull(builder.listeners, "listeners");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
    }

    public RefreshStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long externalTotal() {
        return this.externalTotal;
    }

    public long externalTotalTimeInMillis() {
        return this.externalTotalTimeInMillis;
    }

    public long listeners() {
        return this.listeners;
    }

    public long total() {
        return this.total;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("external_total");
        generator.write(this.externalTotal);
        generator.writeKey("external_total_time_in_millis");
        generator.write(this.externalTotalTimeInMillis);
        generator.writeKey("listeners");
        generator.write(this.listeners);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupRefreshStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::externalTotal, JsonpDeserializer.longDeserializer(), "external_total", new String[0]);
        op.add(Builder::externalTotalTimeInMillis, JsonpDeserializer.longDeserializer(), "external_total_time_in_millis", new String[0]);
        op.add(Builder::listeners, JsonpDeserializer.longDeserializer(), "listeners", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RefreshStats> {
        private Long externalTotal;
        private Long externalTotalTimeInMillis;
        private Long listeners;
        private Long total;
        @Nullable
        private String totalTime;
        private Long totalTimeInMillis;

        public Builder externalTotal(long value) {
            this.externalTotal = value;
            return this;
        }

        public Builder externalTotalTimeInMillis(long value) {
            this.externalTotalTimeInMillis = value;
            return this;
        }

        public Builder listeners(long value) {
            this.listeners = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public RefreshStats build() {
            return new RefreshStats(this);
        }
    }
}

