/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShardStatistics
implements JsonpSerializable {
    private final Number failed;
    private final Number successful;
    private final Number total;
    @Nullable
    private final List<ShardFailure> failures;
    @Nullable
    private final Number skipped;
    public static final JsonpDeserializer<ShardStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStatistics::setupShardStatisticsDeserializer, Builder::build);

    public ShardStatistics(Builder builder) {
        this.failed = Objects.requireNonNull(builder.failed, "failed");
        this.successful = Objects.requireNonNull(builder.successful, "successful");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.failures = ModelTypeHelper.unmodifiable(builder.failures);
        this.skipped = builder.skipped;
    }

    public ShardStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Number failed() {
        return this.failed;
    }

    public Number successful() {
        return this.successful;
    }

    public Number total() {
        return this.total;
    }

    @Nullable
    public List<ShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public Number skipped() {
        return this.skipped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failed");
        generator.write(this.failed.doubleValue());
        generator.writeKey("successful");
        generator.write(this.successful.doubleValue());
        generator.writeKey("total");
        generator.write(this.total.doubleValue());
        if (this.failures != null) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.skipped != null) {
            generator.writeKey("skipped");
            generator.write(this.skipped.doubleValue());
        }
    }

    protected static void setupShardStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::failed, JsonpDeserializer.numberDeserializer(), "failed", new String[0]);
        op.add(Builder::successful, JsonpDeserializer.numberDeserializer(), "successful", new String[0]);
        op.add(Builder::total, JsonpDeserializer.numberDeserializer(), "total", new String[0]);
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures", new String[0]);
        op.add(Builder::skipped, JsonpDeserializer.numberDeserializer(), "skipped", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStatistics> {
        private Number failed;
        private Number successful;
        private Number total;
        @Nullable
        private List<ShardFailure> failures;
        @Nullable
        private Number skipped;

        public Builder failed(Number value) {
            this.failed = value;
            return this;
        }

        public Builder successful(Number value) {
            this.successful = value;
            return this;
        }

        public Builder total(Number value) {
            this.total = value;
            return this;
        }

        public Builder failures(@Nullable List<ShardFailure> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(ShardFailure ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(ShardFailure value) {
            if (this.failures == null) {
                this.failures = new ArrayList<ShardFailure>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build());
        }

        public Builder addFailures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.addFailures(fn.apply(new ShardFailure.Builder()).build());
        }

        public Builder skipped(@Nullable Number value) {
            this.skipped = value;
            return this;
        }

        @Override
        public ShardStatistics build() {
            return new ShardStatistics(this);
        }
    }
}

