/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class BucketAggregationBase
extends AggregationBase {
    @Nullable
    private final Map<String, Aggregation> aggregations;

    public BucketAggregationBase(AbstractBuilder<?> builder) {
        super(builder);
        this.aggregations = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).aggregations);
    }

    @Nullable
    public Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> item0 : this.aggregations.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBucketAggregationBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Map<String, Aggregation> aggregations;

        protected AbstractBuilder() {
        }

        public BuilderT aggregations(@Nullable Map<String, Aggregation> value) {
            this.aggregations = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT putAggregations(String key, Aggregation value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, Aggregation>();
            }
            this.aggregations.put(key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public BuilderT putAggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggregations(key, fn.apply(new Aggregation.Builder()).build());
        }
    }
}

