/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSourceVariant;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class CompositeAggregationSource
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String TERMS = "terms";
    public static final String HISTOGRAM = "histogram";
    public static final String DATE_HISTOGRAM = "date_histogram";
    public static final String GEOTILE_GRID = "geotile_grid";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<CompositeAggregationSource> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, CompositeAggregationSource::setupCompositeAggregationSourceDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public CompositeAggregationSource(CompositeAggregationSourceVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private CompositeAggregationSource(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public CompositeAggregationSource(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public TermsAggregation terms() {
        return (TermsAggregation)TaggedUnionUtils.get(this, TERMS);
    }

    public HistogramAggregation histogram() {
        return (HistogramAggregation)TaggedUnionUtils.get(this, HISTOGRAM);
    }

    public DateHistogramAggregation dateHistogram() {
        return (DateHistogramAggregation)TaggedUnionUtils.get(this, DATE_HISTOGRAM);
    }

    public GeoTileGridAggregation geotileGrid() {
        return (GeoTileGridAggregation)TaggedUnionUtils.get(this, GEOTILE_GRID);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupCompositeAggregationSourceDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::terms, TermsAggregation._DESERIALIZER, TERMS, new String[0]);
        op.add(Builder::histogram, HistogramAggregation._DESERIALIZER, HISTOGRAM, new String[0]);
        op.add(Builder::dateHistogram, DateHistogramAggregation._DESERIALIZER, DATE_HISTOGRAM, new String[0]);
        op.add(Builder::geotileGrid, GeoTileGridAggregation._DESERIALIZER, GEOTILE_GRID, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CompositeAggregationSource> {
        private String _type;
        private Object _value;

        public Builder terms(TermsAggregation v) {
            this._type = CompositeAggregationSource.TERMS;
            this._value = v;
            return this;
        }

        public Builder terms(Function<TermsAggregation.Builder, ObjectBuilder<TermsAggregation>> f) {
            return this.terms(f.apply(new TermsAggregation.Builder()).build());
        }

        public Builder histogram(HistogramAggregation v) {
            this._type = CompositeAggregationSource.HISTOGRAM;
            this._value = v;
            return this;
        }

        public Builder histogram(Function<HistogramAggregation.Builder, ObjectBuilder<HistogramAggregation>> f) {
            return this.histogram(f.apply(new HistogramAggregation.Builder()).build());
        }

        public Builder dateHistogram(DateHistogramAggregation v) {
            this._type = CompositeAggregationSource.DATE_HISTOGRAM;
            this._value = v;
            return this;
        }

        public Builder dateHistogram(Function<DateHistogramAggregation.Builder, ObjectBuilder<DateHistogramAggregation>> f) {
            return this.dateHistogram(f.apply(new DateHistogramAggregation.Builder()).build());
        }

        public Builder geotileGrid(GeoTileGridAggregation v) {
            this._type = CompositeAggregationSource.GEOTILE_GRID;
            this._value = v;
            return this;
        }

        public Builder geotileGrid(Function<GeoTileGridAggregation.Builder, ObjectBuilder<GeoTileGridAggregation>> f) {
            return this.geotileGrid(f.apply(new GeoTileGridAggregation.Builder()).build());
        }

        @Override
        public CompositeAggregationSource build() {
            return new CompositeAggregationSource(this);
        }
    }
}

