/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.ClassificationInferenceOptions;
import co.elastic.clients.elasticsearch._types.aggregations.RegressionInferenceOptions;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InferenceConfig
implements JsonpSerializable {
    @Nullable
    private final RegressionInferenceOptions regression;
    @Nullable
    private final ClassificationInferenceOptions classification;
    public static final JsonpDeserializer<InferenceConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfig::setupInferenceConfigDeserializer, Builder::build);

    public InferenceConfig(Builder builder) {
        this.regression = builder.regression;
        this.classification = builder.classification;
    }

    public InferenceConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public RegressionInferenceOptions regression() {
        return this.regression;
    }

    @Nullable
    public ClassificationInferenceOptions classification() {
        return this.classification;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.regression != null) {
            generator.writeKey("regression");
            this.regression.serialize(generator, mapper);
        }
        if (this.classification != null) {
            generator.writeKey("classification");
            this.classification.serialize(generator, mapper);
        }
    }

    protected static void setupInferenceConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::regression, RegressionInferenceOptions._DESERIALIZER, "regression", new String[0]);
        op.add(Builder::classification, ClassificationInferenceOptions._DESERIALIZER, "classification", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InferenceConfig> {
        @Nullable
        private RegressionInferenceOptions regression;
        @Nullable
        private ClassificationInferenceOptions classification;

        public Builder regression(@Nullable RegressionInferenceOptions value) {
            this.regression = value;
            return this;
        }

        public Builder regression(Function<RegressionInferenceOptions.Builder, ObjectBuilder<RegressionInferenceOptions>> fn) {
            return this.regression(fn.apply(new RegressionInferenceOptions.Builder()).build());
        }

        public Builder classification(@Nullable ClassificationInferenceOptions value) {
            this.classification = value;
            return this;
        }

        public Builder classification(Function<ClassificationInferenceOptions.Builder, ObjectBuilder<ClassificationInferenceOptions>> fn) {
            return this.classification(fn.apply(new ClassificationInferenceOptions.Builder()).build());
        }

        @Override
        public InferenceConfig build() {
            return new InferenceConfig(this);
        }
    }
}

