/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WeightedAverageValue
implements JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Double missing;
    @Nullable
    private final JsonValue script;
    public static final JsonpDeserializer<WeightedAverageValue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageValue::setupWeightedAverageValueDeserializer, Builder::build);

    public WeightedAverageValue(Builder builder) {
        this.field = builder.field;
        this.missing = builder.missing;
        this.script = builder.script;
    }

    public WeightedAverageValue(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public Double missing() {
        return this.missing;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
    }

    protected static void setupWeightedAverageValueDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WeightedAverageValue> {
        @Nullable
        private String field;
        @Nullable
        private Double missing;
        @Nullable
        private JsonValue script;

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        public WeightedAverageValue build() {
            return new WeightedAverageValue(this);
        }
    }
}

