/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterVariant;
import co.elastic.clients.elasticsearch._types.analysis.HtmlStripCharFilter;
import co.elastic.clients.elasticsearch._types.analysis.MappingCharFilter;
import co.elastic.clients.elasticsearch._types.analysis.PatternReplaceTokenFilter;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class CharFilter
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String HTML_STRIP = "html_strip";
    public static final String MAPPING = "mapping";
    public static final String PATTERN_REPLACE = "pattern_replace";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<CharFilter> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, CharFilter::setupCharFilterDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public CharFilter(CharFilterVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private CharFilter(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public CharFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public HtmlStripCharFilter htmlStrip() {
        return (HtmlStripCharFilter)TaggedUnionUtils.get(this, HTML_STRIP);
    }

    public MappingCharFilter mapping() {
        return (MappingCharFilter)TaggedUnionUtils.get(this, MAPPING);
    }

    public PatternReplaceTokenFilter patternReplace() {
        return (PatternReplaceTokenFilter)TaggedUnionUtils.get(this, PATTERN_REPLACE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupCharFilterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::htmlStrip, HtmlStripCharFilter._DESERIALIZER, HTML_STRIP, new String[0]);
        op.add(Builder::mapping, MappingCharFilter._DESERIALIZER, MAPPING, new String[0]);
        op.add(Builder::patternReplace, PatternReplaceTokenFilter._DESERIALIZER, PATTERN_REPLACE, new String[0]);
        op.setTypeProperty("type");
    }

    public static class Builder
    implements ObjectBuilder<CharFilter> {
        private String _type;
        private JsonpSerializable _value;

        public Builder htmlStrip(HtmlStripCharFilter v) {
            this._type = CharFilter.HTML_STRIP;
            this._value = v;
            return this;
        }

        public Builder htmlStrip(Function<HtmlStripCharFilter.Builder, ObjectBuilder<HtmlStripCharFilter>> f) {
            return this.htmlStrip(f.apply(new HtmlStripCharFilter.Builder()).build());
        }

        public Builder mapping(MappingCharFilter v) {
            this._type = CharFilter.MAPPING;
            this._value = v;
            return this;
        }

        public Builder mapping(Function<MappingCharFilter.Builder, ObjectBuilder<MappingCharFilter>> f) {
            return this.mapping(f.apply(new MappingCharFilter.Builder()).build());
        }

        public Builder patternReplace(PatternReplaceTokenFilter v) {
            this._type = CharFilter.PATTERN_REPLACE;
            this._value = v;
            return this;
        }

        public Builder patternReplace(Function<PatternReplaceTokenFilter.Builder, ObjectBuilder<PatternReplaceTokenFilter>> f) {
            return this.patternReplace(f.apply(new PatternReplaceTokenFilter.Builder()).build());
        }

        @Override
        public CharFilter build() {
            return new CharFilter(this);
        }
    }
}

