/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KuromojiReadingFormTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean useRomaji;
    public static final JsonpDeserializer<KuromojiReadingFormTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiReadingFormTokenFilter::setupKuromojiReadingFormTokenFilterDeserializer, Builder::build);

    public KuromojiReadingFormTokenFilter(Builder builder) {
        super(builder);
        this.useRomaji = Objects.requireNonNull(builder.useRomaji, "use_romaji");
    }

    public KuromojiReadingFormTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "kuromoji_readingform";
    }

    public boolean useRomaji() {
        return this.useRomaji;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_readingform");
        super.serializeInternal(generator, mapper);
        generator.writeKey("use_romaji");
        generator.write(this.useRomaji);
    }

    protected static void setupKuromojiReadingFormTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::useRomaji, JsonpDeserializer.booleanDeserializer(), "use_romaji", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiReadingFormTokenFilter> {
        private Boolean useRomaji;

        public Builder useRomaji(boolean value) {
            this.useRomaji = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiReadingFormTokenFilter build() {
            return new KuromojiReadingFormTokenFilter(this);
        }
    }
}

