/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NGramTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final int maxGram;
    private final int minGram;
    public static final JsonpDeserializer<NGramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NGramTokenFilter::setupNGramTokenFilterDeserializer, Builder::build);

    public NGramTokenFilter(Builder builder) {
        super(builder);
        this.maxGram = Objects.requireNonNull(builder.maxGram, "max_gram");
        this.minGram = Objects.requireNonNull(builder.minGram, "min_gram");
    }

    public NGramTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "ngram";
    }

    public int maxGram() {
        return this.maxGram;
    }

    public int minGram() {
        return this.minGram;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ngram");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max_gram");
        generator.write(this.maxGram);
        generator.writeKey("min_gram");
        generator.write(this.minGram);
    }

    protected static void setupNGramTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram", new String[0]);
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NGramTokenFilter> {
        private Integer maxGram;
        private Integer minGram;

        public Builder maxGram(int value) {
            this.maxGram = value;
            return this;
        }

        public Builder minGram(int value) {
            this.minGram = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NGramTokenFilter build() {
            return new NGramTokenFilter(this);
        }
    }
}

