/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.NoriDecompoundMode;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NoriTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final NoriDecompoundMode decompoundMode;
    private final boolean discardPunctuation;
    private final String userDictionary;
    private final List<String> userDictionaryRules;
    public static final JsonpDeserializer<NoriTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriTokenizer::setupNoriTokenizerDeserializer, Builder::build);

    public NoriTokenizer(Builder builder) {
        super(builder);
        this.decompoundMode = Objects.requireNonNull(builder.decompoundMode, "decompound_mode");
        this.discardPunctuation = Objects.requireNonNull(builder.discardPunctuation, "discard_punctuation");
        this.userDictionary = Objects.requireNonNull(builder.userDictionary, "user_dictionary");
        this.userDictionaryRules = ModelTypeHelper.unmodifiableNonNull(builder.userDictionaryRules, "user_dictionary_rules");
    }

    public NoriTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "nori_tokenizer";
    }

    public NoriDecompoundMode decompoundMode() {
        return this.decompoundMode;
    }

    public boolean discardPunctuation() {
        return this.discardPunctuation;
    }

    public String userDictionary() {
        return this.userDictionary;
    }

    public List<String> userDictionaryRules() {
        return this.userDictionaryRules;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori_tokenizer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("decompound_mode");
        this.decompoundMode.serialize(generator, mapper);
        generator.writeKey("discard_punctuation");
        generator.write(this.discardPunctuation);
        generator.writeKey("user_dictionary");
        generator.write(this.userDictionary);
        generator.writeKey("user_dictionary_rules");
        generator.writeStartArray();
        for (String item0 : this.userDictionaryRules) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupNoriTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::decompoundMode, NoriDecompoundMode._DESERIALIZER, "decompound_mode", new String[0]);
        op.add(Builder::discardPunctuation, JsonpDeserializer.booleanDeserializer(), "discard_punctuation", new String[0]);
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary", new String[0]);
        op.add(Builder::userDictionaryRules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "user_dictionary_rules", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NoriTokenizer> {
        private NoriDecompoundMode decompoundMode;
        private Boolean discardPunctuation;
        private String userDictionary;
        private List<String> userDictionaryRules;

        public Builder decompoundMode(NoriDecompoundMode value) {
            this.decompoundMode = value;
            return this;
        }

        public Builder discardPunctuation(boolean value) {
            this.discardPunctuation = value;
            return this;
        }

        public Builder userDictionary(String value) {
            this.userDictionary = value;
            return this;
        }

        public Builder userDictionaryRules(List<String> value) {
            this.userDictionaryRules = value;
            return this;
        }

        public Builder userDictionaryRules(String ... value) {
            this.userDictionaryRules = Arrays.asList(value);
            return this;
        }

        public Builder addUserDictionaryRules(String value) {
            if (this.userDictionaryRules == null) {
                this.userDictionaryRules = new ArrayList<String>();
            }
            this.userDictionaryRules.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NoriTokenizer build() {
            return new NoriTokenizer(this);
        }
    }
}

