/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PatternCaptureTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> patterns;
    private final boolean preserveOriginal;
    public static final JsonpDeserializer<PatternCaptureTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternCaptureTokenFilter::setupPatternCaptureTokenFilterDeserializer, Builder::build);

    public PatternCaptureTokenFilter(Builder builder) {
        super(builder);
        this.patterns = ModelTypeHelper.unmodifiableNonNull(builder.patterns, "patterns");
        this.preserveOriginal = Objects.requireNonNull(builder.preserveOriginal, "preserve_original");
    }

    public PatternCaptureTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "pattern_capture";
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_capture");
        super.serializeInternal(generator, mapper);
        generator.writeKey("patterns");
        generator.writeStartArray();
        for (String item0 : this.patterns) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
    }

    protected static void setupPatternCaptureTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns", new String[0]);
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternCaptureTokenFilter> {
        private List<String> patterns;
        private Boolean preserveOriginal;

        public Builder patterns(List<String> value) {
            this.patterns = value;
            return this;
        }

        public Builder patterns(String ... value) {
            this.patterns = Arrays.asList(value);
            return this;
        }

        public Builder addPatterns(String value) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            this.patterns.add(value);
            return this;
        }

        public Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternCaptureTokenFilter build() {
            return new PatternCaptureTokenFilter(this);
        }
    }
}

