/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharGroupTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.EdgeNGramTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.KeywordTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.LetterTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.LowercaseTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.NGramTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.NoriTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.PathHierarchyTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.StandardTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.elasticsearch._types.analysis.UaxEmailUrlTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.WhitespaceTokenizer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Tokenizer
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String CHAR_GROUP = "char_group";
    public static final String EDGE_NGRAM = "edge_ngram";
    public static final String KEYWORD = "keyword";
    public static final String LETTER = "letter";
    public static final String LOWERCASE = "lowercase";
    public static final String NGRAM = "ngram";
    public static final String NORI_TOKENIZER = "nori_tokenizer";
    public static final String PATH_HIERARCHY = "path_hierarchy";
    public static final String STANDARD = "standard";
    public static final String UAX_URL_EMAIL = "uax_url_email";
    public static final String WHITESPACE = "whitespace";
    public static final String KUROMOJI_TOKENIZER = "kuromoji_tokenizer";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<Tokenizer> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Tokenizer::setupTokenizerDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public Tokenizer(TokenizerVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Tokenizer(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Tokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public CharGroupTokenizer charGroup() {
        return (CharGroupTokenizer)TaggedUnionUtils.get(this, CHAR_GROUP);
    }

    public EdgeNGramTokenizer edgeNgram() {
        return (EdgeNGramTokenizer)TaggedUnionUtils.get(this, EDGE_NGRAM);
    }

    public KeywordTokenizer keyword() {
        return (KeywordTokenizer)TaggedUnionUtils.get(this, KEYWORD);
    }

    public LetterTokenizer letter() {
        return (LetterTokenizer)TaggedUnionUtils.get(this, LETTER);
    }

    public LowercaseTokenizer lowercase() {
        return (LowercaseTokenizer)TaggedUnionUtils.get(this, LOWERCASE);
    }

    public NGramTokenizer ngram() {
        return (NGramTokenizer)TaggedUnionUtils.get(this, NGRAM);
    }

    public NoriTokenizer noriTokenizer() {
        return (NoriTokenizer)TaggedUnionUtils.get(this, NORI_TOKENIZER);
    }

    public PathHierarchyTokenizer pathHierarchy() {
        return (PathHierarchyTokenizer)TaggedUnionUtils.get(this, PATH_HIERARCHY);
    }

    public StandardTokenizer standard() {
        return (StandardTokenizer)TaggedUnionUtils.get(this, STANDARD);
    }

    public UaxEmailUrlTokenizer uaxUrlEmail() {
        return (UaxEmailUrlTokenizer)TaggedUnionUtils.get(this, UAX_URL_EMAIL);
    }

    public WhitespaceTokenizer whitespace() {
        return (WhitespaceTokenizer)TaggedUnionUtils.get(this, WHITESPACE);
    }

    public KuromojiTokenizer kuromojiTokenizer() {
        return (KuromojiTokenizer)TaggedUnionUtils.get(this, KUROMOJI_TOKENIZER);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charGroup, CharGroupTokenizer._DESERIALIZER, CHAR_GROUP, new String[0]);
        op.add(Builder::edgeNgram, EdgeNGramTokenizer._DESERIALIZER, EDGE_NGRAM, new String[0]);
        op.add(Builder::keyword, KeywordTokenizer._DESERIALIZER, KEYWORD, new String[0]);
        op.add(Builder::letter, LetterTokenizer._DESERIALIZER, LETTER, new String[0]);
        op.add(Builder::lowercase, LowercaseTokenizer._DESERIALIZER, LOWERCASE, new String[0]);
        op.add(Builder::ngram, NGramTokenizer._DESERIALIZER, NGRAM, new String[0]);
        op.add(Builder::noriTokenizer, NoriTokenizer._DESERIALIZER, NORI_TOKENIZER, new String[0]);
        op.add(Builder::pathHierarchy, PathHierarchyTokenizer._DESERIALIZER, PATH_HIERARCHY, new String[0]);
        op.add(Builder::standard, StandardTokenizer._DESERIALIZER, STANDARD, new String[0]);
        op.add(Builder::uaxUrlEmail, UaxEmailUrlTokenizer._DESERIALIZER, UAX_URL_EMAIL, new String[0]);
        op.add(Builder::whitespace, WhitespaceTokenizer._DESERIALIZER, WHITESPACE, new String[0]);
        op.add(Builder::kuromojiTokenizer, KuromojiTokenizer._DESERIALIZER, KUROMOJI_TOKENIZER, new String[0]);
        op.setTypeProperty("type");
    }

    public static class Builder
    implements ObjectBuilder<Tokenizer> {
        private String _type;
        private JsonpSerializable _value;

        public Builder charGroup(CharGroupTokenizer v) {
            this._type = Tokenizer.CHAR_GROUP;
            this._value = v;
            return this;
        }

        public Builder charGroup(Function<CharGroupTokenizer.Builder, ObjectBuilder<CharGroupTokenizer>> f) {
            return this.charGroup(f.apply(new CharGroupTokenizer.Builder()).build());
        }

        public Builder edgeNgram(EdgeNGramTokenizer v) {
            this._type = Tokenizer.EDGE_NGRAM;
            this._value = v;
            return this;
        }

        public Builder edgeNgram(Function<EdgeNGramTokenizer.Builder, ObjectBuilder<EdgeNGramTokenizer>> f) {
            return this.edgeNgram(f.apply(new EdgeNGramTokenizer.Builder()).build());
        }

        public Builder keyword(KeywordTokenizer v) {
            this._type = Tokenizer.KEYWORD;
            this._value = v;
            return this;
        }

        public Builder keyword(Function<KeywordTokenizer.Builder, ObjectBuilder<KeywordTokenizer>> f) {
            return this.keyword(f.apply(new KeywordTokenizer.Builder()).build());
        }

        public Builder letter(LetterTokenizer v) {
            this._type = Tokenizer.LETTER;
            this._value = v;
            return this;
        }

        public Builder letter(Function<LetterTokenizer.Builder, ObjectBuilder<LetterTokenizer>> f) {
            return this.letter(f.apply(new LetterTokenizer.Builder()).build());
        }

        public Builder lowercase(LowercaseTokenizer v) {
            this._type = Tokenizer.LOWERCASE;
            this._value = v;
            return this;
        }

        public Builder lowercase(Function<LowercaseTokenizer.Builder, ObjectBuilder<LowercaseTokenizer>> f) {
            return this.lowercase(f.apply(new LowercaseTokenizer.Builder()).build());
        }

        public Builder ngram(NGramTokenizer v) {
            this._type = Tokenizer.NGRAM;
            this._value = v;
            return this;
        }

        public Builder ngram(Function<NGramTokenizer.Builder, ObjectBuilder<NGramTokenizer>> f) {
            return this.ngram(f.apply(new NGramTokenizer.Builder()).build());
        }

        public Builder noriTokenizer(NoriTokenizer v) {
            this._type = Tokenizer.NORI_TOKENIZER;
            this._value = v;
            return this;
        }

        public Builder noriTokenizer(Function<NoriTokenizer.Builder, ObjectBuilder<NoriTokenizer>> f) {
            return this.noriTokenizer(f.apply(new NoriTokenizer.Builder()).build());
        }

        public Builder pathHierarchy(PathHierarchyTokenizer v) {
            this._type = Tokenizer.PATH_HIERARCHY;
            this._value = v;
            return this;
        }

        public Builder pathHierarchy(Function<PathHierarchyTokenizer.Builder, ObjectBuilder<PathHierarchyTokenizer>> f) {
            return this.pathHierarchy(f.apply(new PathHierarchyTokenizer.Builder()).build());
        }

        public Builder standard(StandardTokenizer v) {
            this._type = Tokenizer.STANDARD;
            this._value = v;
            return this;
        }

        public Builder standard(Function<StandardTokenizer.Builder, ObjectBuilder<StandardTokenizer>> f) {
            return this.standard(f.apply(new StandardTokenizer.Builder()).build());
        }

        public Builder uaxUrlEmail(UaxEmailUrlTokenizer v) {
            this._type = Tokenizer.UAX_URL_EMAIL;
            this._value = v;
            return this;
        }

        public Builder uaxUrlEmail(Function<UaxEmailUrlTokenizer.Builder, ObjectBuilder<UaxEmailUrlTokenizer>> f) {
            return this.uaxUrlEmail(f.apply(new UaxEmailUrlTokenizer.Builder()).build());
        }

        public Builder whitespace(WhitespaceTokenizer v) {
            this._type = Tokenizer.WHITESPACE;
            this._value = v;
            return this;
        }

        public Builder whitespace(Function<WhitespaceTokenizer.Builder, ObjectBuilder<WhitespaceTokenizer>> f) {
            return this.whitespace(f.apply(new WhitespaceTokenizer.Builder()).build());
        }

        public Builder kuromojiTokenizer(KuromojiTokenizer v) {
            this._type = Tokenizer.KUROMOJI_TOKENIZER;
            this._value = v;
            return this;
        }

        public Builder kuromojiTokenizer(Function<KuromojiTokenizer.Builder, ObjectBuilder<KuromojiTokenizer>> f) {
            return this.kuromojiTokenizer(f.apply(new KuromojiTokenizer.Builder()).build());
        }

        @Override
        public Tokenizer build() {
            return new Tokenizer(this);
        }
    }
}

