/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class UniqueTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean onlyOnSamePosition;
    public static final JsonpDeserializer<UniqueTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UniqueTokenFilter::setupUniqueTokenFilterDeserializer, Builder::build);

    public UniqueTokenFilter(Builder builder) {
        super(builder);
        this.onlyOnSamePosition = Objects.requireNonNull(builder.onlyOnSamePosition, "only_on_same_position");
    }

    public UniqueTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "unique";
    }

    public boolean onlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "unique");
        super.serializeInternal(generator, mapper);
        generator.writeKey("only_on_same_position");
        generator.write(this.onlyOnSamePosition);
    }

    protected static void setupUniqueTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::onlyOnSamePosition, JsonpDeserializer.booleanDeserializer(), "only_on_same_position", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UniqueTokenFilter> {
        private Boolean onlyOnSamePosition;

        public Builder onlyOnSamePosition(boolean value) {
            this.onlyOnSamePosition = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UniqueTokenFilter build() {
            return new UniqueTokenFilter(this);
        }
    }
}

