/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class WordDelimiterTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean catenateAll;
    private final boolean catenateNumbers;
    private final boolean catenateWords;
    private final boolean generateNumberParts;
    private final boolean generateWordParts;
    private final boolean preserveOriginal;
    private final List<String> protectedWords;
    private final String protectedWordsPath;
    private final boolean splitOnCaseChange;
    private final boolean splitOnNumerics;
    private final boolean stemEnglishPossessive;
    private final List<String> typeTable;
    private final String typeTablePath;
    public static final JsonpDeserializer<WordDelimiterTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WordDelimiterTokenFilter::setupWordDelimiterTokenFilterDeserializer, Builder::build);

    public WordDelimiterTokenFilter(Builder builder) {
        super(builder);
        this.catenateAll = Objects.requireNonNull(builder.catenateAll, "catenate_all");
        this.catenateNumbers = Objects.requireNonNull(builder.catenateNumbers, "catenate_numbers");
        this.catenateWords = Objects.requireNonNull(builder.catenateWords, "catenate_words");
        this.generateNumberParts = Objects.requireNonNull(builder.generateNumberParts, "generate_number_parts");
        this.generateWordParts = Objects.requireNonNull(builder.generateWordParts, "generate_word_parts");
        this.preserveOriginal = Objects.requireNonNull(builder.preserveOriginal, "preserve_original");
        this.protectedWords = ModelTypeHelper.unmodifiableNonNull(builder.protectedWords, "protected_words");
        this.protectedWordsPath = Objects.requireNonNull(builder.protectedWordsPath, "protected_words_path");
        this.splitOnCaseChange = Objects.requireNonNull(builder.splitOnCaseChange, "split_on_case_change");
        this.splitOnNumerics = Objects.requireNonNull(builder.splitOnNumerics, "split_on_numerics");
        this.stemEnglishPossessive = Objects.requireNonNull(builder.stemEnglishPossessive, "stem_english_possessive");
        this.typeTable = ModelTypeHelper.unmodifiableNonNull(builder.typeTable, "type_table");
        this.typeTablePath = Objects.requireNonNull(builder.typeTablePath, "type_table_path");
    }

    public WordDelimiterTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "word_delimiter";
    }

    public boolean catenateAll() {
        return this.catenateAll;
    }

    public boolean catenateNumbers() {
        return this.catenateNumbers;
    }

    public boolean catenateWords() {
        return this.catenateWords;
    }

    public boolean generateNumberParts() {
        return this.generateNumberParts;
    }

    public boolean generateWordParts() {
        return this.generateWordParts;
    }

    public boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    public List<String> protectedWords() {
        return this.protectedWords;
    }

    public String protectedWordsPath() {
        return this.protectedWordsPath;
    }

    public boolean splitOnCaseChange() {
        return this.splitOnCaseChange;
    }

    public boolean splitOnNumerics() {
        return this.splitOnNumerics;
    }

    public boolean stemEnglishPossessive() {
        return this.stemEnglishPossessive;
    }

    public List<String> typeTable() {
        return this.typeTable;
    }

    public String typeTablePath() {
        return this.typeTablePath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "word_delimiter");
        super.serializeInternal(generator, mapper);
        generator.writeKey("catenate_all");
        generator.write(this.catenateAll);
        generator.writeKey("catenate_numbers");
        generator.write(this.catenateNumbers);
        generator.writeKey("catenate_words");
        generator.write(this.catenateWords);
        generator.writeKey("generate_number_parts");
        generator.write(this.generateNumberParts);
        generator.writeKey("generate_word_parts");
        generator.write(this.generateWordParts);
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
        generator.writeKey("protected_words");
        generator.writeStartArray();
        for (String item0 : this.protectedWords) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("protected_words_path");
        generator.write(this.protectedWordsPath);
        generator.writeKey("split_on_case_change");
        generator.write(this.splitOnCaseChange);
        generator.writeKey("split_on_numerics");
        generator.write(this.splitOnNumerics);
        generator.writeKey("stem_english_possessive");
        generator.write(this.stemEnglishPossessive);
        generator.writeKey("type_table");
        generator.writeStartArray();
        for (String item0 : this.typeTable) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("type_table_path");
        generator.write(this.typeTablePath);
    }

    protected static void setupWordDelimiterTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::catenateAll, JsonpDeserializer.booleanDeserializer(), "catenate_all", new String[0]);
        op.add(Builder::catenateNumbers, JsonpDeserializer.booleanDeserializer(), "catenate_numbers", new String[0]);
        op.add(Builder::catenateWords, JsonpDeserializer.booleanDeserializer(), "catenate_words", new String[0]);
        op.add(Builder::generateNumberParts, JsonpDeserializer.booleanDeserializer(), "generate_number_parts", new String[0]);
        op.add(Builder::generateWordParts, JsonpDeserializer.booleanDeserializer(), "generate_word_parts", new String[0]);
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original", new String[0]);
        op.add(Builder::protectedWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "protected_words", new String[0]);
        op.add(Builder::protectedWordsPath, JsonpDeserializer.stringDeserializer(), "protected_words_path", new String[0]);
        op.add(Builder::splitOnCaseChange, JsonpDeserializer.booleanDeserializer(), "split_on_case_change", new String[0]);
        op.add(Builder::splitOnNumerics, JsonpDeserializer.booleanDeserializer(), "split_on_numerics", new String[0]);
        op.add(Builder::stemEnglishPossessive, JsonpDeserializer.booleanDeserializer(), "stem_english_possessive", new String[0]);
        op.add(Builder::typeTable, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "type_table", new String[0]);
        op.add(Builder::typeTablePath, JsonpDeserializer.stringDeserializer(), "type_table_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WordDelimiterTokenFilter> {
        private Boolean catenateAll;
        private Boolean catenateNumbers;
        private Boolean catenateWords;
        private Boolean generateNumberParts;
        private Boolean generateWordParts;
        private Boolean preserveOriginal;
        private List<String> protectedWords;
        private String protectedWordsPath;
        private Boolean splitOnCaseChange;
        private Boolean splitOnNumerics;
        private Boolean stemEnglishPossessive;
        private List<String> typeTable;
        private String typeTablePath;

        public Builder catenateAll(boolean value) {
            this.catenateAll = value;
            return this;
        }

        public Builder catenateNumbers(boolean value) {
            this.catenateNumbers = value;
            return this;
        }

        public Builder catenateWords(boolean value) {
            this.catenateWords = value;
            return this;
        }

        public Builder generateNumberParts(boolean value) {
            this.generateNumberParts = value;
            return this;
        }

        public Builder generateWordParts(boolean value) {
            this.generateWordParts = value;
            return this;
        }

        public Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        public Builder protectedWords(List<String> value) {
            this.protectedWords = value;
            return this;
        }

        public Builder protectedWords(String ... value) {
            this.protectedWords = Arrays.asList(value);
            return this;
        }

        public Builder addProtectedWords(String value) {
            if (this.protectedWords == null) {
                this.protectedWords = new ArrayList<String>();
            }
            this.protectedWords.add(value);
            return this;
        }

        public Builder protectedWordsPath(String value) {
            this.protectedWordsPath = value;
            return this;
        }

        public Builder splitOnCaseChange(boolean value) {
            this.splitOnCaseChange = value;
            return this;
        }

        public Builder splitOnNumerics(boolean value) {
            this.splitOnNumerics = value;
            return this;
        }

        public Builder stemEnglishPossessive(boolean value) {
            this.stemEnglishPossessive = value;
            return this;
        }

        public Builder typeTable(List<String> value) {
            this.typeTable = value;
            return this;
        }

        public Builder typeTable(String ... value) {
            this.typeTable = Arrays.asList(value);
            return this;
        }

        public Builder addTypeTable(String value) {
            if (this.typeTable == null) {
                this.typeTable = new ArrayList<String>();
            }
            this.typeTable.add(value);
            return this;
        }

        public Builder typeTablePath(String value) {
            this.typeTablePath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WordDelimiterTokenFilter build() {
            return new WordDelimiterTokenFilter(this);
        }
    }
}

