/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class KeywordProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final String normalizer;
    @Nullable
    private final Boolean norms;
    @Nullable
    private final String nullValue;
    @Nullable
    private final Boolean splitQueriesOnWhitespace;
    public static final JsonpDeserializer<KeywordProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordProperty::setupKeywordPropertyDeserializer, Builder::build);

    public KeywordProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.normalizer = builder.normalizer;
        this.norms = builder.norms;
        this.nullValue = builder.nullValue;
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace;
    }

    public KeywordProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "keyword";
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public String normalizer() {
        return this.normalizer;
    }

    @Nullable
    public Boolean norms() {
        return this.norms;
    }

    @Nullable
    public String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public Boolean splitQueriesOnWhitespace() {
        return this.splitQueriesOnWhitespace;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.splitQueriesOnWhitespace != null) {
            generator.writeKey("split_queries_on_whitespace");
            generator.write(this.splitQueriesOnWhitespace.booleanValue());
        }
    }

    protected static void setupKeywordPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options", new String[0]);
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer", new String[0]);
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms", new String[0]);
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value", new String[0]);
        op.add(Builder::splitQueriesOnWhitespace, JsonpDeserializer.booleanDeserializer(), "split_queries_on_whitespace", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeywordProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private String normalizer;
        @Nullable
        private Boolean norms;
        @Nullable
        private String nullValue;
        @Nullable
        private Boolean splitQueriesOnWhitespace;

        public Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        public Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        public Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        public Builder splitQueriesOnWhitespace(@Nullable Boolean value) {
            this.splitQueriesOnWhitespace = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeywordProperty build() {
            return new KeywordProperty(this);
        }
    }
}

