/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RankFeatureProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean positiveScoreImpact;
    public static final JsonpDeserializer<RankFeatureProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureProperty::setupRankFeaturePropertyDeserializer, Builder::build);

    public RankFeatureProperty(Builder builder) {
        super(builder);
        this.positiveScoreImpact = builder.positiveScoreImpact;
    }

    public RankFeatureProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "rank_feature";
    }

    @Nullable
    public Boolean positiveScoreImpact() {
        return this.positiveScoreImpact;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "rank_feature");
        super.serializeInternal(generator, mapper);
        if (this.positiveScoreImpact != null) {
            generator.writeKey("positive_score_impact");
            generator.write(this.positiveScoreImpact.booleanValue());
        }
    }

    protected static void setupRankFeaturePropertyDeserializer(DelegatingDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::positiveScoreImpact, JsonpDeserializer.booleanDeserializer(), "positive_score_impact", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RankFeatureProperty> {
        @Nullable
        private Boolean positiveScoreImpact;

        public Builder positiveScoreImpact(@Nullable Boolean value) {
            this.positiveScoreImpact = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankFeatureProperty build() {
            return new RankFeatureProperty(this);
        }
    }
}

