/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.CombinedFieldsOperator;
import co.elastic.clients.elasticsearch._types.query_dsl.CombinedFieldsZeroTerms;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CombinedFieldsQuery
extends QueryBase
implements QueryVariant {
    private final List<String> fields;
    private final String query;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final CombinedFieldsOperator operator;
    @Nullable
    private final String mimimumShouldMatch;
    @Nullable
    private final CombinedFieldsZeroTerms zeroTermsQuery;
    public static final JsonpDeserializer<CombinedFieldsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CombinedFieldsQuery::setupCombinedFieldsQueryDeserializer, Builder::build);

    public CombinedFieldsQuery(Builder builder) {
        super(builder);
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
        this.query = Objects.requireNonNull(builder.query, "query");
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.operator = builder.operator;
        this.mimimumShouldMatch = builder.mimimumShouldMatch;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public CombinedFieldsQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "combined_fields";
    }

    public List<String> fields() {
        return this.fields;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public CombinedFieldsOperator operator() {
        return this.operator;
    }

    @Nullable
    public String mimimumShouldMatch() {
        return this.mimimumShouldMatch;
    }

    @Nullable
    public CombinedFieldsZeroTerms zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("fields");
        generator.writeStartArray();
        for (String item0 : this.fields) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("query");
        generator.write(this.query);
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.operator != null) {
            generator.writeKey("operator");
            this.operator.serialize(generator, mapper);
        }
        if (this.mimimumShouldMatch != null) {
            generator.writeKey("mimimum_should_match");
            generator.write(this.mimimumShouldMatch);
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
    }

    protected static void setupCombinedFieldsQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query", new String[0]);
        op.add(Builder::operator, CombinedFieldsOperator._DESERIALIZER, "operator", new String[0]);
        op.add(Builder::mimimumShouldMatch, JsonpDeserializer.stringDeserializer(), "mimimum_should_match", new String[0]);
        op.add(Builder::zeroTermsQuery, CombinedFieldsZeroTerms._DESERIALIZER, "zero_terms_query", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CombinedFieldsQuery> {
        private List<String> fields;
        private String query;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private CombinedFieldsOperator operator;
        @Nullable
        private String mimimumShouldMatch;
        @Nullable
        private CombinedFieldsZeroTerms zeroTermsQuery;

        public Builder fields(List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public Builder operator(@Nullable CombinedFieldsOperator value) {
            this.operator = value;
            return this;
        }

        public Builder mimimumShouldMatch(@Nullable String value) {
            this.mimimumShouldMatch = value;
            return this;
        }

        public Builder zeroTermsQuery(@Nullable CombinedFieldsZeroTerms value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CombinedFieldsQuery build() {
            return new CombinedFieldsQuery(this);
        }
    }
}

