/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.BoostingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.CombinedFieldsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.CommonTermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ConstantScoreQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DisMaxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ExistsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.FuzzyQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoBoundingBoxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoDistanceQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoPolygonQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoShapeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.HasChildQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.HasParentQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IdsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchBoolPrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchNoneQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhrasePrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhraseQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MoreLikeThisQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MultiMatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ParentIdQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PercolateQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PinnedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RegexpQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ShapeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SimpleQueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanContainingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanFieldMaskingQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanFirstQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanMultiTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanNearQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanNotQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanOrQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanWithinQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsSetQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TypeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Query
implements TaggedUnion<Object>,
AggregationVariant,
JsonpSerializable {
    public static final String BOOL = "bool";
    public static final String BOOSTING = "boosting";
    public static final String COMMON = "common";
    public static final String COMBINED_FIELDS = "combined_fields";
    public static final String CONSTANT_SCORE = "constant_score";
    public static final String DIS_MAX = "dis_max";
    public static final String DISTANCE_FEATURE = "distance_feature";
    public static final String EXISTS = "exists";
    public static final String FUNCTION_SCORE = "function_score";
    public static final String FUZZY = "fuzzy";
    public static final String GEO_BOUNDING_BOX = "geo_bounding_box";
    public static final String GEO_DISTANCE = "geo_distance";
    public static final String GEO_POLYGON = "geo_polygon";
    public static final String GEO_SHAPE = "geo_shape";
    public static final String HAS_CHILD = "has_child";
    public static final String HAS_PARENT = "has_parent";
    public static final String IDS = "ids";
    public static final String INTERVALS = "intervals";
    public static final String MATCH = "match";
    public static final String MATCH_ALL = "match_all";
    public static final String MATCH_BOOL_PREFIX = "match_bool_prefix";
    public static final String MATCH_NONE = "match_none";
    public static final String MATCH_PHRASE = "match_phrase";
    public static final String MATCH_PHRASE_PREFIX = "match_phrase_prefix";
    public static final String MORE_LIKE_THIS = "more_like_this";
    public static final String MULTI_MATCH = "multi_match";
    public static final String NESTED = "nested";
    public static final String PARENT_ID = "parent_id";
    public static final String PERCOLATE = "percolate";
    public static final String PINNED = "pinned";
    public static final String PREFIX = "prefix";
    public static final String QUERY_STRING = "query_string";
    public static final String RANGE = "range";
    public static final String RANK_FEATURE = "rank_feature";
    public static final String REGEXP = "regexp";
    public static final String SCRIPT = "script";
    public static final String SCRIPT_SCORE = "script_score";
    public static final String SHAPE = "shape";
    public static final String SIMPLE_QUERY_STRING = "simple_query_string";
    public static final String SPAN_CONTAINING = "span_containing";
    public static final String FIELD_MASKING_SPAN = "field_masking_span";
    public static final String SPAN_FIRST = "span_first";
    public static final String SPAN_MULTI = "span_multi";
    public static final String SPAN_NEAR = "span_near";
    public static final String SPAN_NOT = "span_not";
    public static final String SPAN_OR = "span_or";
    public static final String SPAN_TERM = "span_term";
    public static final String SPAN_WITHIN = "span_within";
    public static final String TERM = "term";
    public static final String TERMS = "terms";
    public static final String TERMS_SET = "terms_set";
    public static final String WILDCARD = "wildcard";
    public static final String TYPE = "type";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Query> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Query::setupQueryDeserializer, Builder::build);

    @Override
    public String _variantType() {
        return "filter";
    }

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Query(QueryVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Query(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Query(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public BoolQuery bool() {
        return (BoolQuery)TaggedUnionUtils.get(this, BOOL);
    }

    public BoostingQuery boosting() {
        return (BoostingQuery)TaggedUnionUtils.get(this, BOOSTING);
    }

    public CommonTermsQuery common() {
        return (CommonTermsQuery)TaggedUnionUtils.get(this, COMMON);
    }

    public CombinedFieldsQuery combinedFields() {
        return (CombinedFieldsQuery)TaggedUnionUtils.get(this, COMBINED_FIELDS);
    }

    public ConstantScoreQuery constantScore() {
        return (ConstantScoreQuery)TaggedUnionUtils.get(this, CONSTANT_SCORE);
    }

    public DisMaxQuery disMax() {
        return (DisMaxQuery)TaggedUnionUtils.get(this, DIS_MAX);
    }

    public JsonValue distanceFeature() {
        return (JsonValue)TaggedUnionUtils.get(this, DISTANCE_FEATURE);
    }

    public ExistsQuery exists() {
        return (ExistsQuery)TaggedUnionUtils.get(this, EXISTS);
    }

    public FunctionScoreQuery functionScore() {
        return (FunctionScoreQuery)TaggedUnionUtils.get(this, FUNCTION_SCORE);
    }

    public FuzzyQuery fuzzy() {
        return (FuzzyQuery)TaggedUnionUtils.get(this, FUZZY);
    }

    public GeoBoundingBoxQuery geoBoundingBox() {
        return (GeoBoundingBoxQuery)TaggedUnionUtils.get(this, GEO_BOUNDING_BOX);
    }

    public GeoDistanceQuery geoDistance() {
        return (GeoDistanceQuery)TaggedUnionUtils.get(this, GEO_DISTANCE);
    }

    public GeoPolygonQuery geoPolygon() {
        return (GeoPolygonQuery)TaggedUnionUtils.get(this, GEO_POLYGON);
    }

    public GeoShapeQuery geoShape() {
        return (GeoShapeQuery)TaggedUnionUtils.get(this, GEO_SHAPE);
    }

    public HasChildQuery hasChild() {
        return (HasChildQuery)TaggedUnionUtils.get(this, HAS_CHILD);
    }

    public HasParentQuery hasParent() {
        return (HasParentQuery)TaggedUnionUtils.get(this, HAS_PARENT);
    }

    public IdsQuery ids() {
        return (IdsQuery)TaggedUnionUtils.get(this, IDS);
    }

    public IntervalsQuery intervals() {
        return (IntervalsQuery)TaggedUnionUtils.get(this, INTERVALS);
    }

    public MatchQuery match() {
        return (MatchQuery)TaggedUnionUtils.get(this, MATCH);
    }

    public MatchAllQuery matchAll() {
        return (MatchAllQuery)TaggedUnionUtils.get(this, MATCH_ALL);
    }

    public MatchBoolPrefixQuery matchBoolPrefix() {
        return (MatchBoolPrefixQuery)TaggedUnionUtils.get(this, MATCH_BOOL_PREFIX);
    }

    public MatchNoneQuery matchNone() {
        return (MatchNoneQuery)TaggedUnionUtils.get(this, MATCH_NONE);
    }

    public MatchPhraseQuery matchPhrase() {
        return (MatchPhraseQuery)TaggedUnionUtils.get(this, MATCH_PHRASE);
    }

    public MatchPhrasePrefixQuery matchPhrasePrefix() {
        return (MatchPhrasePrefixQuery)TaggedUnionUtils.get(this, MATCH_PHRASE_PREFIX);
    }

    public MoreLikeThisQuery moreLikeThis() {
        return (MoreLikeThisQuery)TaggedUnionUtils.get(this, MORE_LIKE_THIS);
    }

    public MultiMatchQuery multiMatch() {
        return (MultiMatchQuery)TaggedUnionUtils.get(this, MULTI_MATCH);
    }

    public NestedQuery nested() {
        return (NestedQuery)TaggedUnionUtils.get(this, NESTED);
    }

    public ParentIdQuery parentId() {
        return (ParentIdQuery)TaggedUnionUtils.get(this, PARENT_ID);
    }

    public PercolateQuery percolate() {
        return (PercolateQuery)TaggedUnionUtils.get(this, PERCOLATE);
    }

    public PinnedQuery pinned() {
        return (PinnedQuery)TaggedUnionUtils.get(this, PINNED);
    }

    public PrefixQuery prefix() {
        return (PrefixQuery)TaggedUnionUtils.get(this, PREFIX);
    }

    public QueryStringQuery queryString() {
        return (QueryStringQuery)TaggedUnionUtils.get(this, QUERY_STRING);
    }

    public JsonValue range() {
        return (JsonValue)TaggedUnionUtils.get(this, RANGE);
    }

    public RankFeatureQuery rankFeature() {
        return (RankFeatureQuery)TaggedUnionUtils.get(this, RANK_FEATURE);
    }

    public RegexpQuery regexp() {
        return (RegexpQuery)TaggedUnionUtils.get(this, REGEXP);
    }

    public ScriptQuery script() {
        return (ScriptQuery)TaggedUnionUtils.get(this, SCRIPT);
    }

    public ScriptScoreQuery scriptScore() {
        return (ScriptScoreQuery)TaggedUnionUtils.get(this, SCRIPT_SCORE);
    }

    public ShapeQuery shape() {
        return (ShapeQuery)TaggedUnionUtils.get(this, SHAPE);
    }

    public SimpleQueryStringQuery simpleQueryString() {
        return (SimpleQueryStringQuery)TaggedUnionUtils.get(this, SIMPLE_QUERY_STRING);
    }

    public SpanContainingQuery spanContaining() {
        return (SpanContainingQuery)TaggedUnionUtils.get(this, SPAN_CONTAINING);
    }

    public SpanFieldMaskingQuery fieldMaskingSpan() {
        return (SpanFieldMaskingQuery)TaggedUnionUtils.get(this, FIELD_MASKING_SPAN);
    }

    public SpanFirstQuery spanFirst() {
        return (SpanFirstQuery)TaggedUnionUtils.get(this, SPAN_FIRST);
    }

    public SpanMultiTermQuery spanMulti() {
        return (SpanMultiTermQuery)TaggedUnionUtils.get(this, SPAN_MULTI);
    }

    public SpanNearQuery spanNear() {
        return (SpanNearQuery)TaggedUnionUtils.get(this, SPAN_NEAR);
    }

    public SpanNotQuery spanNot() {
        return (SpanNotQuery)TaggedUnionUtils.get(this, SPAN_NOT);
    }

    public SpanOrQuery spanOr() {
        return (SpanOrQuery)TaggedUnionUtils.get(this, SPAN_OR);
    }

    public SpanTermQuery spanTerm() {
        return (SpanTermQuery)TaggedUnionUtils.get(this, SPAN_TERM);
    }

    public SpanWithinQuery spanWithin() {
        return (SpanWithinQuery)TaggedUnionUtils.get(this, SPAN_WITHIN);
    }

    public TermQuery term() {
        return (TermQuery)TaggedUnionUtils.get(this, TERM);
    }

    public TermsQuery terms() {
        return (TermsQuery)TaggedUnionUtils.get(this, TERMS);
    }

    public TermsSetQuery termsSet() {
        return (TermsSetQuery)TaggedUnionUtils.get(this, TERMS_SET);
    }

    public WildcardQuery wildcard() {
        return (WildcardQuery)TaggedUnionUtils.get(this, WILDCARD);
    }

    public TypeQuery type() {
        return (TypeQuery)TaggedUnionUtils.get(this, TYPE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "distance_feature": {
                    generator.write((JsonValue)this._value);
                    break;
                }
                case "range": {
                    generator.write((JsonValue)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupQueryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bool, BoolQuery._DESERIALIZER, BOOL, new String[0]);
        op.add(Builder::boosting, BoostingQuery._DESERIALIZER, BOOSTING, new String[0]);
        op.add(Builder::common, CommonTermsQuery._DESERIALIZER, COMMON, new String[0]);
        op.add(Builder::combinedFields, CombinedFieldsQuery._DESERIALIZER, COMBINED_FIELDS, new String[0]);
        op.add(Builder::constantScore, ConstantScoreQuery._DESERIALIZER, CONSTANT_SCORE, new String[0]);
        op.add(Builder::disMax, DisMaxQuery._DESERIALIZER, DIS_MAX, new String[0]);
        op.add(Builder::distanceFeature, JsonpDeserializer.jsonValueDeserializer(), DISTANCE_FEATURE, new String[0]);
        op.add(Builder::exists, ExistsQuery._DESERIALIZER, EXISTS, new String[0]);
        op.add(Builder::functionScore, FunctionScoreQuery._DESERIALIZER, FUNCTION_SCORE, new String[0]);
        op.add(Builder::fuzzy, FuzzyQuery._DESERIALIZER, FUZZY, new String[0]);
        op.add(Builder::geoBoundingBox, GeoBoundingBoxQuery._DESERIALIZER, GEO_BOUNDING_BOX, new String[0]);
        op.add(Builder::geoDistance, GeoDistanceQuery._DESERIALIZER, GEO_DISTANCE, new String[0]);
        op.add(Builder::geoPolygon, GeoPolygonQuery._DESERIALIZER, GEO_POLYGON, new String[0]);
        op.add(Builder::geoShape, GeoShapeQuery._DESERIALIZER, GEO_SHAPE, new String[0]);
        op.add(Builder::hasChild, HasChildQuery._DESERIALIZER, HAS_CHILD, new String[0]);
        op.add(Builder::hasParent, HasParentQuery._DESERIALIZER, HAS_PARENT, new String[0]);
        op.add(Builder::ids, IdsQuery._DESERIALIZER, IDS, new String[0]);
        op.add(Builder::intervals, IntervalsQuery._DESERIALIZER, INTERVALS, new String[0]);
        op.add(Builder::match, MatchQuery._DESERIALIZER, MATCH, new String[0]);
        op.add(Builder::matchAll, MatchAllQuery._DESERIALIZER, MATCH_ALL, new String[0]);
        op.add(Builder::matchBoolPrefix, MatchBoolPrefixQuery._DESERIALIZER, MATCH_BOOL_PREFIX, new String[0]);
        op.add(Builder::matchNone, MatchNoneQuery._DESERIALIZER, MATCH_NONE, new String[0]);
        op.add(Builder::matchPhrase, MatchPhraseQuery._DESERIALIZER, MATCH_PHRASE, new String[0]);
        op.add(Builder::matchPhrasePrefix, MatchPhrasePrefixQuery._DESERIALIZER, MATCH_PHRASE_PREFIX, new String[0]);
        op.add(Builder::moreLikeThis, MoreLikeThisQuery._DESERIALIZER, MORE_LIKE_THIS, new String[0]);
        op.add(Builder::multiMatch, MultiMatchQuery._DESERIALIZER, MULTI_MATCH, new String[0]);
        op.add(Builder::nested, NestedQuery._DESERIALIZER, NESTED, new String[0]);
        op.add(Builder::parentId, ParentIdQuery._DESERIALIZER, PARENT_ID, new String[0]);
        op.add(Builder::percolate, PercolateQuery._DESERIALIZER, PERCOLATE, new String[0]);
        op.add(Builder::pinned, PinnedQuery._DESERIALIZER, PINNED, new String[0]);
        op.add(Builder::prefix, PrefixQuery._DESERIALIZER, PREFIX, new String[0]);
        op.add(Builder::queryString, QueryStringQuery._DESERIALIZER, QUERY_STRING, new String[0]);
        op.add(Builder::range, JsonpDeserializer.jsonValueDeserializer(), RANGE, new String[0]);
        op.add(Builder::rankFeature, RankFeatureQuery._DESERIALIZER, RANK_FEATURE, new String[0]);
        op.add(Builder::regexp, RegexpQuery._DESERIALIZER, REGEXP, new String[0]);
        op.add(Builder::script, ScriptQuery._DESERIALIZER, SCRIPT, new String[0]);
        op.add(Builder::scriptScore, ScriptScoreQuery._DESERIALIZER, SCRIPT_SCORE, new String[0]);
        op.add(Builder::shape, ShapeQuery._DESERIALIZER, SHAPE, new String[0]);
        op.add(Builder::simpleQueryString, SimpleQueryStringQuery._DESERIALIZER, SIMPLE_QUERY_STRING, new String[0]);
        op.add(Builder::spanContaining, SpanContainingQuery._DESERIALIZER, SPAN_CONTAINING, new String[0]);
        op.add(Builder::fieldMaskingSpan, SpanFieldMaskingQuery._DESERIALIZER, FIELD_MASKING_SPAN, new String[0]);
        op.add(Builder::spanFirst, SpanFirstQuery._DESERIALIZER, SPAN_FIRST, new String[0]);
        op.add(Builder::spanMulti, SpanMultiTermQuery._DESERIALIZER, SPAN_MULTI, new String[0]);
        op.add(Builder::spanNear, SpanNearQuery._DESERIALIZER, SPAN_NEAR, new String[0]);
        op.add(Builder::spanNot, SpanNotQuery._DESERIALIZER, SPAN_NOT, new String[0]);
        op.add(Builder::spanOr, SpanOrQuery._DESERIALIZER, SPAN_OR, new String[0]);
        op.add(Builder::spanTerm, SpanTermQuery._DESERIALIZER, SPAN_TERM, new String[0]);
        op.add(Builder::spanWithin, SpanWithinQuery._DESERIALIZER, SPAN_WITHIN, new String[0]);
        op.add(Builder::term, TermQuery._DESERIALIZER, TERM, new String[0]);
        op.add(Builder::terms, TermsQuery._DESERIALIZER, TERMS, new String[0]);
        op.add(Builder::termsSet, TermsSetQuery._DESERIALIZER, TERMS_SET, new String[0]);
        op.add(Builder::wildcard, WildcardQuery._DESERIALIZER, WILDCARD, new String[0]);
        op.add(Builder::type, TypeQuery._DESERIALIZER, TYPE, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Query> {
        private String _type;
        private Object _value;

        public Builder bool(BoolQuery v) {
            this._type = Query.BOOL;
            this._value = v;
            return this;
        }

        public Builder bool(Function<BoolQuery.Builder, ObjectBuilder<BoolQuery>> f) {
            return this.bool(f.apply(new BoolQuery.Builder()).build());
        }

        public Builder boosting(BoostingQuery v) {
            this._type = Query.BOOSTING;
            this._value = v;
            return this;
        }

        public Builder boosting(Function<BoostingQuery.Builder, ObjectBuilder<BoostingQuery>> f) {
            return this.boosting(f.apply(new BoostingQuery.Builder()).build());
        }

        public Builder common(CommonTermsQuery v) {
            this._type = Query.COMMON;
            this._value = v;
            return this;
        }

        public Builder common(Function<CommonTermsQuery.Builder, ObjectBuilder<CommonTermsQuery>> f) {
            return this.common(f.apply(new CommonTermsQuery.Builder()).build());
        }

        public Builder combinedFields(CombinedFieldsQuery v) {
            this._type = Query.COMBINED_FIELDS;
            this._value = v;
            return this;
        }

        public Builder combinedFields(Function<CombinedFieldsQuery.Builder, ObjectBuilder<CombinedFieldsQuery>> f) {
            return this.combinedFields(f.apply(new CombinedFieldsQuery.Builder()).build());
        }

        public Builder constantScore(ConstantScoreQuery v) {
            this._type = Query.CONSTANT_SCORE;
            this._value = v;
            return this;
        }

        public Builder constantScore(Function<ConstantScoreQuery.Builder, ObjectBuilder<ConstantScoreQuery>> f) {
            return this.constantScore(f.apply(new ConstantScoreQuery.Builder()).build());
        }

        public Builder disMax(DisMaxQuery v) {
            this._type = Query.DIS_MAX;
            this._value = v;
            return this;
        }

        public Builder disMax(Function<DisMaxQuery.Builder, ObjectBuilder<DisMaxQuery>> f) {
            return this.disMax(f.apply(new DisMaxQuery.Builder()).build());
        }

        public Builder distanceFeature(JsonValue v) {
            this._type = Query.DISTANCE_FEATURE;
            this._value = v;
            return this;
        }

        public Builder exists(ExistsQuery v) {
            this._type = Query.EXISTS;
            this._value = v;
            return this;
        }

        public Builder exists(Function<ExistsQuery.Builder, ObjectBuilder<ExistsQuery>> f) {
            return this.exists(f.apply(new ExistsQuery.Builder()).build());
        }

        public Builder functionScore(FunctionScoreQuery v) {
            this._type = Query.FUNCTION_SCORE;
            this._value = v;
            return this;
        }

        public Builder functionScore(Function<FunctionScoreQuery.Builder, ObjectBuilder<FunctionScoreQuery>> f) {
            return this.functionScore(f.apply(new FunctionScoreQuery.Builder()).build());
        }

        public Builder fuzzy(FuzzyQuery v) {
            this._type = Query.FUZZY;
            this._value = v;
            return this;
        }

        public Builder fuzzy(Function<FuzzyQuery.Builder, ObjectBuilder<FuzzyQuery>> f) {
            return this.fuzzy(f.apply(new FuzzyQuery.Builder()).build());
        }

        public Builder geoBoundingBox(GeoBoundingBoxQuery v) {
            this._type = Query.GEO_BOUNDING_BOX;
            this._value = v;
            return this;
        }

        public Builder geoBoundingBox(Function<GeoBoundingBoxQuery.Builder, ObjectBuilder<GeoBoundingBoxQuery>> f) {
            return this.geoBoundingBox(f.apply(new GeoBoundingBoxQuery.Builder()).build());
        }

        public Builder geoDistance(GeoDistanceQuery v) {
            this._type = Query.GEO_DISTANCE;
            this._value = v;
            return this;
        }

        public Builder geoDistance(Function<GeoDistanceQuery.Builder, ObjectBuilder<GeoDistanceQuery>> f) {
            return this.geoDistance(f.apply(new GeoDistanceQuery.Builder()).build());
        }

        public Builder geoPolygon(GeoPolygonQuery v) {
            this._type = Query.GEO_POLYGON;
            this._value = v;
            return this;
        }

        public Builder geoPolygon(Function<GeoPolygonQuery.Builder, ObjectBuilder<GeoPolygonQuery>> f) {
            return this.geoPolygon(f.apply(new GeoPolygonQuery.Builder()).build());
        }

        public Builder geoShape(GeoShapeQuery v) {
            this._type = Query.GEO_SHAPE;
            this._value = v;
            return this;
        }

        public Builder geoShape(Function<GeoShapeQuery.Builder, ObjectBuilder<GeoShapeQuery>> f) {
            return this.geoShape(f.apply(new GeoShapeQuery.Builder()).build());
        }

        public Builder hasChild(HasChildQuery v) {
            this._type = Query.HAS_CHILD;
            this._value = v;
            return this;
        }

        public Builder hasChild(Function<HasChildQuery.Builder, ObjectBuilder<HasChildQuery>> f) {
            return this.hasChild(f.apply(new HasChildQuery.Builder()).build());
        }

        public Builder hasParent(HasParentQuery v) {
            this._type = Query.HAS_PARENT;
            this._value = v;
            return this;
        }

        public Builder hasParent(Function<HasParentQuery.Builder, ObjectBuilder<HasParentQuery>> f) {
            return this.hasParent(f.apply(new HasParentQuery.Builder()).build());
        }

        public Builder ids(IdsQuery v) {
            this._type = Query.IDS;
            this._value = v;
            return this;
        }

        public Builder ids(Function<IdsQuery.Builder, ObjectBuilder<IdsQuery>> f) {
            return this.ids(f.apply(new IdsQuery.Builder()).build());
        }

        public Builder intervals(IntervalsQuery v) {
            this._type = Query.INTERVALS;
            this._value = v;
            return this;
        }

        public Builder intervals(Function<IntervalsQuery.Builder, ObjectBuilder<IntervalsQuery>> f) {
            return this.intervals(f.apply(new IntervalsQuery.Builder()).build());
        }

        public Builder match(MatchQuery v) {
            this._type = Query.MATCH;
            this._value = v;
            return this;
        }

        public Builder match(Function<MatchQuery.Builder, ObjectBuilder<MatchQuery>> f) {
            return this.match(f.apply(new MatchQuery.Builder()).build());
        }

        public Builder matchAll(MatchAllQuery v) {
            this._type = Query.MATCH_ALL;
            this._value = v;
            return this;
        }

        public Builder matchAll(Function<MatchAllQuery.Builder, ObjectBuilder<MatchAllQuery>> f) {
            return this.matchAll(f.apply(new MatchAllQuery.Builder()).build());
        }

        public Builder matchBoolPrefix(MatchBoolPrefixQuery v) {
            this._type = Query.MATCH_BOOL_PREFIX;
            this._value = v;
            return this;
        }

        public Builder matchBoolPrefix(Function<MatchBoolPrefixQuery.Builder, ObjectBuilder<MatchBoolPrefixQuery>> f) {
            return this.matchBoolPrefix(f.apply(new MatchBoolPrefixQuery.Builder()).build());
        }

        public Builder matchNone(MatchNoneQuery v) {
            this._type = Query.MATCH_NONE;
            this._value = v;
            return this;
        }

        public Builder matchNone(Function<MatchNoneQuery.Builder, ObjectBuilder<MatchNoneQuery>> f) {
            return this.matchNone(f.apply(new MatchNoneQuery.Builder()).build());
        }

        public Builder matchPhrase(MatchPhraseQuery v) {
            this._type = Query.MATCH_PHRASE;
            this._value = v;
            return this;
        }

        public Builder matchPhrase(Function<MatchPhraseQuery.Builder, ObjectBuilder<MatchPhraseQuery>> f) {
            return this.matchPhrase(f.apply(new MatchPhraseQuery.Builder()).build());
        }

        public Builder matchPhrasePrefix(MatchPhrasePrefixQuery v) {
            this._type = Query.MATCH_PHRASE_PREFIX;
            this._value = v;
            return this;
        }

        public Builder matchPhrasePrefix(Function<MatchPhrasePrefixQuery.Builder, ObjectBuilder<MatchPhrasePrefixQuery>> f) {
            return this.matchPhrasePrefix(f.apply(new MatchPhrasePrefixQuery.Builder()).build());
        }

        public Builder moreLikeThis(MoreLikeThisQuery v) {
            this._type = Query.MORE_LIKE_THIS;
            this._value = v;
            return this;
        }

        public Builder moreLikeThis(Function<MoreLikeThisQuery.Builder, ObjectBuilder<MoreLikeThisQuery>> f) {
            return this.moreLikeThis(f.apply(new MoreLikeThisQuery.Builder()).build());
        }

        public Builder multiMatch(MultiMatchQuery v) {
            this._type = Query.MULTI_MATCH;
            this._value = v;
            return this;
        }

        public Builder multiMatch(Function<MultiMatchQuery.Builder, ObjectBuilder<MultiMatchQuery>> f) {
            return this.multiMatch(f.apply(new MultiMatchQuery.Builder()).build());
        }

        public Builder nested(NestedQuery v) {
            this._type = Query.NESTED;
            this._value = v;
            return this;
        }

        public Builder nested(Function<NestedQuery.Builder, ObjectBuilder<NestedQuery>> f) {
            return this.nested(f.apply(new NestedQuery.Builder()).build());
        }

        public Builder parentId(ParentIdQuery v) {
            this._type = Query.PARENT_ID;
            this._value = v;
            return this;
        }

        public Builder parentId(Function<ParentIdQuery.Builder, ObjectBuilder<ParentIdQuery>> f) {
            return this.parentId(f.apply(new ParentIdQuery.Builder()).build());
        }

        public Builder percolate(PercolateQuery v) {
            this._type = Query.PERCOLATE;
            this._value = v;
            return this;
        }

        public Builder percolate(Function<PercolateQuery.Builder, ObjectBuilder<PercolateQuery>> f) {
            return this.percolate(f.apply(new PercolateQuery.Builder()).build());
        }

        public Builder pinned(PinnedQuery v) {
            this._type = Query.PINNED;
            this._value = v;
            return this;
        }

        public Builder pinned(Function<PinnedQuery.Builder, ObjectBuilder<PinnedQuery>> f) {
            return this.pinned(f.apply(new PinnedQuery.Builder()).build());
        }

        public Builder prefix(PrefixQuery v) {
            this._type = Query.PREFIX;
            this._value = v;
            return this;
        }

        public Builder prefix(Function<PrefixQuery.Builder, ObjectBuilder<PrefixQuery>> f) {
            return this.prefix(f.apply(new PrefixQuery.Builder()).build());
        }

        public Builder queryString(QueryStringQuery v) {
            this._type = Query.QUERY_STRING;
            this._value = v;
            return this;
        }

        public Builder queryString(Function<QueryStringQuery.Builder, ObjectBuilder<QueryStringQuery>> f) {
            return this.queryString(f.apply(new QueryStringQuery.Builder()).build());
        }

        public Builder range(JsonValue v) {
            this._type = Query.RANGE;
            this._value = v;
            return this;
        }

        public Builder rankFeature(RankFeatureQuery v) {
            this._type = Query.RANK_FEATURE;
            this._value = v;
            return this;
        }

        public Builder rankFeature(Function<RankFeatureQuery.Builder, ObjectBuilder<RankFeatureQuery>> f) {
            return this.rankFeature(f.apply(new RankFeatureQuery.Builder()).build());
        }

        public Builder regexp(RegexpQuery v) {
            this._type = Query.REGEXP;
            this._value = v;
            return this;
        }

        public Builder regexp(Function<RegexpQuery.Builder, ObjectBuilder<RegexpQuery>> f) {
            return this.regexp(f.apply(new RegexpQuery.Builder()).build());
        }

        public Builder script(ScriptQuery v) {
            this._type = Query.SCRIPT;
            this._value = v;
            return this;
        }

        public Builder script(Function<ScriptQuery.Builder, ObjectBuilder<ScriptQuery>> f) {
            return this.script(f.apply(new ScriptQuery.Builder()).build());
        }

        public Builder scriptScore(ScriptScoreQuery v) {
            this._type = Query.SCRIPT_SCORE;
            this._value = v;
            return this;
        }

        public Builder scriptScore(Function<ScriptScoreQuery.Builder, ObjectBuilder<ScriptScoreQuery>> f) {
            return this.scriptScore(f.apply(new ScriptScoreQuery.Builder()).build());
        }

        public Builder shape(ShapeQuery v) {
            this._type = Query.SHAPE;
            this._value = v;
            return this;
        }

        public Builder shape(Function<ShapeQuery.Builder, ObjectBuilder<ShapeQuery>> f) {
            return this.shape(f.apply(new ShapeQuery.Builder()).build());
        }

        public Builder simpleQueryString(SimpleQueryStringQuery v) {
            this._type = Query.SIMPLE_QUERY_STRING;
            this._value = v;
            return this;
        }

        public Builder simpleQueryString(Function<SimpleQueryStringQuery.Builder, ObjectBuilder<SimpleQueryStringQuery>> f) {
            return this.simpleQueryString(f.apply(new SimpleQueryStringQuery.Builder()).build());
        }

        public Builder spanContaining(SpanContainingQuery v) {
            this._type = Query.SPAN_CONTAINING;
            this._value = v;
            return this;
        }

        public Builder spanContaining(Function<SpanContainingQuery.Builder, ObjectBuilder<SpanContainingQuery>> f) {
            return this.spanContaining(f.apply(new SpanContainingQuery.Builder()).build());
        }

        public Builder fieldMaskingSpan(SpanFieldMaskingQuery v) {
            this._type = Query.FIELD_MASKING_SPAN;
            this._value = v;
            return this;
        }

        public Builder fieldMaskingSpan(Function<SpanFieldMaskingQuery.Builder, ObjectBuilder<SpanFieldMaskingQuery>> f) {
            return this.fieldMaskingSpan(f.apply(new SpanFieldMaskingQuery.Builder()).build());
        }

        public Builder spanFirst(SpanFirstQuery v) {
            this._type = Query.SPAN_FIRST;
            this._value = v;
            return this;
        }

        public Builder spanFirst(Function<SpanFirstQuery.Builder, ObjectBuilder<SpanFirstQuery>> f) {
            return this.spanFirst(f.apply(new SpanFirstQuery.Builder()).build());
        }

        public Builder spanMulti(SpanMultiTermQuery v) {
            this._type = Query.SPAN_MULTI;
            this._value = v;
            return this;
        }

        public Builder spanMulti(Function<SpanMultiTermQuery.Builder, ObjectBuilder<SpanMultiTermQuery>> f) {
            return this.spanMulti(f.apply(new SpanMultiTermQuery.Builder()).build());
        }

        public Builder spanNear(SpanNearQuery v) {
            this._type = Query.SPAN_NEAR;
            this._value = v;
            return this;
        }

        public Builder spanNear(Function<SpanNearQuery.Builder, ObjectBuilder<SpanNearQuery>> f) {
            return this.spanNear(f.apply(new SpanNearQuery.Builder()).build());
        }

        public Builder spanNot(SpanNotQuery v) {
            this._type = Query.SPAN_NOT;
            this._value = v;
            return this;
        }

        public Builder spanNot(Function<SpanNotQuery.Builder, ObjectBuilder<SpanNotQuery>> f) {
            return this.spanNot(f.apply(new SpanNotQuery.Builder()).build());
        }

        public Builder spanOr(SpanOrQuery v) {
            this._type = Query.SPAN_OR;
            this._value = v;
            return this;
        }

        public Builder spanOr(Function<SpanOrQuery.Builder, ObjectBuilder<SpanOrQuery>> f) {
            return this.spanOr(f.apply(new SpanOrQuery.Builder()).build());
        }

        public Builder spanTerm(SpanTermQuery v) {
            this._type = Query.SPAN_TERM;
            this._value = v;
            return this;
        }

        public Builder spanTerm(Function<SpanTermQuery.Builder, ObjectBuilder<SpanTermQuery>> f) {
            return this.spanTerm(f.apply(new SpanTermQuery.Builder()).build());
        }

        public Builder spanWithin(SpanWithinQuery v) {
            this._type = Query.SPAN_WITHIN;
            this._value = v;
            return this;
        }

        public Builder spanWithin(Function<SpanWithinQuery.Builder, ObjectBuilder<SpanWithinQuery>> f) {
            return this.spanWithin(f.apply(new SpanWithinQuery.Builder()).build());
        }

        public Builder term(TermQuery v) {
            this._type = Query.TERM;
            this._value = v;
            return this;
        }

        public Builder term(Function<TermQuery.Builder, ObjectBuilder<TermQuery>> f) {
            return this.term(f.apply(new TermQuery.Builder()).build());
        }

        public Builder terms(TermsQuery v) {
            this._type = Query.TERMS;
            this._value = v;
            return this;
        }

        public Builder terms(Function<TermsQuery.Builder, ObjectBuilder<TermsQuery>> f) {
            return this.terms(f.apply(new TermsQuery.Builder()).build());
        }

        public Builder termsSet(TermsSetQuery v) {
            this._type = Query.TERMS_SET;
            this._value = v;
            return this;
        }

        public Builder termsSet(Function<TermsSetQuery.Builder, ObjectBuilder<TermsSetQuery>> f) {
            return this.termsSet(f.apply(new TermsSetQuery.Builder()).build());
        }

        public Builder wildcard(WildcardQuery v) {
            this._type = Query.WILDCARD;
            this._value = v;
            return this;
        }

        public Builder wildcard(Function<WildcardQuery.Builder, ObjectBuilder<WildcardQuery>> f) {
            return this.wildcard(f.apply(new WildcardQuery.Builder()).build());
        }

        public Builder type(TypeQuery v) {
            this._type = Query.TYPE;
            this._value = v;
            return this;
        }

        public Builder type(Function<TypeQuery.Builder, ObjectBuilder<TypeQuery>> f) {
            return this.type(f.apply(new TypeQuery.Builder()).build());
        }

        @Override
        public Query build() {
            return new Query(this);
        }
    }
}

