/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SpanTermQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final String field;
    private final String value;
    public static final JsonpDeserializer<SpanTermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanTermQuery::setupSpanTermQueryDeserializer, Builder::build);

    public SpanTermQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public SpanTermQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "span_term";
    }

    public String field() {
        return this.field;
    }

    public String value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
        generator.writeEnd();
    }

    protected static void setupSpanTermQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value", new String[0]);
        op.setKey(Builder::field);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanTermQuery> {
        private String field;
        private String value;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanTermQuery build() {
            return new SpanTermQuery(this);
        }
    }
}

