/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AsyncSearchResponseBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final boolean isPartial;
    private final boolean isRunning;
    private final String expirationTimeInMillis;
    private final String startTimeInMillis;

    public AsyncSearchResponseBase(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.isPartial = Objects.requireNonNull(((AbstractBuilder)builder).isPartial, "is_partial");
        this.isRunning = Objects.requireNonNull(((AbstractBuilder)builder).isRunning, "is_running");
        this.expirationTimeInMillis = Objects.requireNonNull(((AbstractBuilder)builder).expirationTimeInMillis, "expiration_time_in_millis");
        this.startTimeInMillis = Objects.requireNonNull(((AbstractBuilder)builder).startTimeInMillis, "start_time_in_millis");
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    public String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        generator.writeKey("expiration_time_in_millis");
        generator.write(this.expirationTimeInMillis);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAsyncSearchResponseBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(AbstractBuilder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial", new String[0]);
        op.add(AbstractBuilder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running", new String[0]);
        op.add(AbstractBuilder::expirationTimeInMillis, JsonpDeserializer.stringDeserializer(), "expiration_time_in_millis", new String[0]);
        op.add(AbstractBuilder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String id;
        private Boolean isPartial;
        private Boolean isRunning;
        private String expirationTimeInMillis;
        private String startTimeInMillis;

        protected AbstractBuilder() {
        }

        public BuilderT id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        public BuilderT isPartial(boolean value) {
            this.isPartial = value;
            return this.self();
        }

        public BuilderT isRunning(boolean value) {
            this.isRunning = value;
            return this.self();
        }

        public BuilderT expirationTimeInMillis(String value) {
            this.expirationTimeInMillis = value;
            return this.self();
        }

        public BuilderT startTimeInMillis(String value) {
            this.startTimeInMillis = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

