/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.ThreadPoolResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ThreadPoolRequest
extends CatRequestBase {
    @Nullable
    private final List<String> threadPoolPatterns;
    @Nullable
    private final JsonValue size;
    public static final Endpoint<ThreadPoolRequest, ThreadPoolResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ThreadPoolRequest, ThreadPoolResponse>(request -> "GET", request -> {
        boolean _threadPoolPatterns = true;
        boolean propsSet = false;
        if (request.threadPoolPatterns() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/thread_pool");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/thread_pool");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.threadPoolPatterns.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", JsonpUtils.toString(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ThreadPoolResponse._DESERIALIZER);

    public ThreadPoolRequest(Builder builder) {
        this.threadPoolPatterns = ModelTypeHelper.unmodifiable(builder.threadPoolPatterns);
        this.size = builder.size;
    }

    public ThreadPoolRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> threadPoolPatterns() {
        return this.threadPoolPatterns;
    }

    @Nullable
    public JsonValue size() {
        return this.size;
    }

    public static class Builder
    implements ObjectBuilder<ThreadPoolRequest> {
        @Nullable
        private List<String> threadPoolPatterns;
        @Nullable
        private JsonValue size;

        public Builder threadPoolPatterns(@Nullable List<String> value) {
            this.threadPoolPatterns = value;
            return this;
        }

        public Builder threadPoolPatterns(String ... value) {
            this.threadPoolPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addThreadPoolPatterns(String value) {
            if (this.threadPoolPatterns == null) {
                this.threadPoolPatterns = new ArrayList<String>();
            }
            this.threadPoolPatterns.add(value);
            return this;
        }

        public Builder size(@Nullable JsonValue value) {
            this.size = value;
            return this;
        }

        @Override
        public ThreadPoolRequest build() {
            return new ThreadPoolRequest(this);
        }
    }
}

