/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ccr.ForgetFollowerResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ForgetFollowerRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String followerCluster;
    @Nullable
    private final String followerIndex;
    @Nullable
    private final String followerIndexUuid;
    @Nullable
    private final String leaderRemoteCluster;
    public static final JsonpDeserializer<ForgetFollowerRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForgetFollowerRequest::setupForgetFollowerRequestDeserializer, Builder::build);
    public static final Endpoint<ForgetFollowerRequest, ForgetFollowerResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ForgetFollowerRequest, ForgetFollowerResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ccr");
            buf.append("/forget_follower");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ForgetFollowerResponse._DESERIALIZER);

    public ForgetFollowerRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.followerCluster = builder.followerCluster;
        this.followerIndex = builder.followerIndex;
        this.followerIndexUuid = builder.followerIndexUuid;
        this.leaderRemoteCluster = builder.leaderRemoteCluster;
    }

    public ForgetFollowerRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String followerCluster() {
        return this.followerCluster;
    }

    @Nullable
    public String followerIndex() {
        return this.followerIndex;
    }

    @Nullable
    public String followerIndexUuid() {
        return this.followerIndexUuid;
    }

    @Nullable
    public String leaderRemoteCluster() {
        return this.leaderRemoteCluster;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.followerCluster != null) {
            generator.writeKey("follower_cluster");
            generator.write(this.followerCluster);
        }
        if (this.followerIndex != null) {
            generator.writeKey("follower_index");
            generator.write(this.followerIndex);
        }
        if (this.followerIndexUuid != null) {
            generator.writeKey("follower_index_uuid");
            generator.write(this.followerIndexUuid);
        }
        if (this.leaderRemoteCluster != null) {
            generator.writeKey("leader_remote_cluster");
            generator.write(this.leaderRemoteCluster);
        }
    }

    protected static void setupForgetFollowerRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::followerCluster, JsonpDeserializer.stringDeserializer(), "follower_cluster", new String[0]);
        op.add(Builder::followerIndex, JsonpDeserializer.stringDeserializer(), "follower_index", new String[0]);
        op.add(Builder::followerIndexUuid, JsonpDeserializer.stringDeserializer(), "follower_index_uuid", new String[0]);
        op.add(Builder::leaderRemoteCluster, JsonpDeserializer.stringDeserializer(), "leader_remote_cluster", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ForgetFollowerRequest> {
        private String index;
        @Nullable
        private String followerCluster;
        @Nullable
        private String followerIndex;
        @Nullable
        private String followerIndexUuid;
        @Nullable
        private String leaderRemoteCluster;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder followerCluster(@Nullable String value) {
            this.followerCluster = value;
            return this;
        }

        public Builder followerIndex(@Nullable String value) {
            this.followerIndex = value;
            return this;
        }

        public Builder followerIndexUuid(@Nullable String value) {
            this.followerIndexUuid = value;
            return this;
        }

        public Builder leaderRemoteCluster(@Nullable String value) {
            this.leaderRemoteCluster = value;
            return this;
        }

        @Override
        public ForgetFollowerRequest build() {
            return new ForgetFollowerRequest(this);
        }
    }
}

