/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ReadException
implements JsonpSerializable {
    private final ErrorCause exception;
    private final int fromSeqNo;
    private final int retries;
    public static final JsonpDeserializer<ReadException> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReadException::setupReadExceptionDeserializer, Builder::build);

    public ReadException(Builder builder) {
        this.exception = Objects.requireNonNull(builder.exception, "exception");
        this.fromSeqNo = Objects.requireNonNull(builder.fromSeqNo, "from_seq_no");
        this.retries = Objects.requireNonNull(builder.retries, "retries");
    }

    public ReadException(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ErrorCause exception() {
        return this.exception;
    }

    public int fromSeqNo() {
        return this.fromSeqNo;
    }

    public int retries() {
        return this.retries;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("exception");
        this.exception.serialize(generator, mapper);
        generator.writeKey("from_seq_no");
        generator.write(this.fromSeqNo);
        generator.writeKey("retries");
        generator.write(this.retries);
    }

    protected static void setupReadExceptionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::exception, ErrorCause._DESERIALIZER, "exception", new String[0]);
        op.add(Builder::fromSeqNo, JsonpDeserializer.integerDeserializer(), "from_seq_no", new String[0]);
        op.add(Builder::retries, JsonpDeserializer.integerDeserializer(), "retries", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReadException> {
        private ErrorCause exception;
        private Integer fromSeqNo;
        private Integer retries;

        public Builder exception(ErrorCause value) {
            this.exception = value;
            return this;
        }

        public Builder exception(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.exception(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder fromSeqNo(int value) {
            this.fromSeqNo = value;
            return this;
        }

        public Builder retries(int value) {
            this.retries = value;
            return this;
        }

        @Override
        public ReadException build() {
            return new ReadException(this);
        }
    }
}

