/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.get_auto_follow_pattern;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AutoFollowPatternSummary
implements JsonpSerializable {
    private final boolean active;
    private final String remoteCluster;
    @Nullable
    private final String followIndexPattern;
    private final List<String> leaderIndexPatterns;
    private final List<String> leaderIndexExclusionPatterns;
    private final int maxOutstandingReadRequests;
    public static final JsonpDeserializer<AutoFollowPatternSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoFollowPatternSummary::setupAutoFollowPatternSummaryDeserializer, Builder::build);

    public AutoFollowPatternSummary(Builder builder) {
        this.active = Objects.requireNonNull(builder.active, "active");
        this.remoteCluster = Objects.requireNonNull(builder.remoteCluster, "remote_cluster");
        this.followIndexPattern = builder.followIndexPattern;
        this.leaderIndexPatterns = ModelTypeHelper.unmodifiableNonNull(builder.leaderIndexPatterns, "leader_index_patterns");
        this.leaderIndexExclusionPatterns = ModelTypeHelper.unmodifiableNonNull(builder.leaderIndexExclusionPatterns, "leader_index_exclusion_patterns");
        this.maxOutstandingReadRequests = Objects.requireNonNull(builder.maxOutstandingReadRequests, "max_outstanding_read_requests");
    }

    public AutoFollowPatternSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean active() {
        return this.active;
    }

    public String remoteCluster() {
        return this.remoteCluster;
    }

    @Nullable
    public String followIndexPattern() {
        return this.followIndexPattern;
    }

    public List<String> leaderIndexPatterns() {
        return this.leaderIndexPatterns;
    }

    public List<String> leaderIndexExclusionPatterns() {
        return this.leaderIndexExclusionPatterns;
    }

    public int maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        if (this.followIndexPattern != null) {
            generator.writeKey("follow_index_pattern");
            generator.write(this.followIndexPattern);
        }
        generator.writeKey("leader_index_patterns");
        generator.writeStartArray();
        for (String item0 : this.leaderIndexPatterns) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("leader_index_exclusion_patterns");
        generator.writeStartArray();
        for (String item0 : this.leaderIndexExclusionPatterns) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("max_outstanding_read_requests");
        generator.write(this.maxOutstandingReadRequests);
    }

    protected static void setupAutoFollowPatternSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.booleanDeserializer(), "active", new String[0]);
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster", new String[0]);
        op.add(Builder::followIndexPattern, JsonpDeserializer.stringDeserializer(), "follow_index_pattern", new String[0]);
        op.add(Builder::leaderIndexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_patterns", new String[0]);
        op.add(Builder::leaderIndexExclusionPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_exclusion_patterns", new String[0]);
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_read_requests", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoFollowPatternSummary> {
        private Boolean active;
        private String remoteCluster;
        @Nullable
        private String followIndexPattern;
        private List<String> leaderIndexPatterns;
        private List<String> leaderIndexExclusionPatterns;
        private Integer maxOutstandingReadRequests;

        public Builder active(boolean value) {
            this.active = value;
            return this;
        }

        public Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public Builder followIndexPattern(@Nullable String value) {
            this.followIndexPattern = value;
            return this;
        }

        public Builder leaderIndexPatterns(List<String> value) {
            this.leaderIndexPatterns = value;
            return this;
        }

        public Builder leaderIndexPatterns(String ... value) {
            this.leaderIndexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addLeaderIndexPatterns(String value) {
            if (this.leaderIndexPatterns == null) {
                this.leaderIndexPatterns = new ArrayList<String>();
            }
            this.leaderIndexPatterns.add(value);
            return this;
        }

        public Builder leaderIndexExclusionPatterns(List<String> value) {
            this.leaderIndexExclusionPatterns = value;
            return this;
        }

        public Builder leaderIndexExclusionPatterns(String ... value) {
            this.leaderIndexExclusionPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addLeaderIndexExclusionPatterns(String value) {
            if (this.leaderIndexExclusionPatterns == null) {
                this.leaderIndexExclusionPatterns = new ArrayList<String>();
            }
            this.leaderIndexExclusionPatterns.add(value);
            return this;
        }

        public Builder maxOutstandingReadRequests(int value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        @Override
        public AutoFollowPatternSummary build() {
            return new AutoFollowPatternSummary(this);
        }
    }
}

