/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.StateResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class StateRequest
extends RequestBase {
    @Nullable
    private final List<String> metric;
    @Nullable
    private final List<String> index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Long waitForMetadataVersion;
    @Nullable
    private final String waitForTimeout;
    public static final Endpoint<StateRequest, StateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StateRequest, StateResponse>(request -> "GET", request -> {
        boolean _metric = true;
        int _index = 2;
        int propsSet = 0;
        if (request.metric() != null) {
            propsSet |= 1;
        }
        if (request.index() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/state");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/state");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/state");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.waitForMetadataVersion != null) {
            params.put("wait_for_metadata_version", String.valueOf(request.waitForMetadataVersion));
        }
        if (request.waitForTimeout != null) {
            params.put("wait_for_timeout", request.waitForTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StateResponse._DESERIALIZER);

    public StateRequest(Builder builder) {
        this.metric = ModelTypeHelper.unmodifiable(builder.metric);
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.flatSettings = builder.flatSettings;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.waitForMetadataVersion = builder.waitForMetadataVersion;
        this.waitForTimeout = builder.waitForTimeout;
    }

    public StateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> metric() {
        return this.metric;
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Long waitForMetadataVersion() {
        return this.waitForMetadataVersion;
    }

    @Nullable
    public String waitForTimeout() {
        return this.waitForTimeout;
    }

    public static class Builder
    implements ObjectBuilder<StateRequest> {
        @Nullable
        private List<String> metric;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Long waitForMetadataVersion;
        @Nullable
        private String waitForTimeout;

        public Builder metric(@Nullable List<String> value) {
            this.metric = value;
            return this;
        }

        public Builder metric(String ... value) {
            this.metric = Arrays.asList(value);
            return this;
        }

        public Builder addMetric(String value) {
            if (this.metric == null) {
                this.metric = new ArrayList<String>();
            }
            this.metric.add(value);
            return this;
        }

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder waitForMetadataVersion(@Nullable Long value) {
            this.waitForMetadataVersion = value;
            return this;
        }

        public Builder waitForTimeout(@Nullable String value) {
            this.waitForTimeout = value;
            return this;
        }

        @Override
        public StateRequest build() {
            return new StateRequest(this);
        }
    }
}

