/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.NodeDiskUsage;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.ReservedSize;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ClusterInfo
implements JsonpSerializable {
    private final Map<String, NodeDiskUsage> nodes;
    private final Map<String, Long> shardSizes;
    @Nullable
    private final Map<String, String> shardDataSetSizes;
    private final Map<String, String> shardPaths;
    private final List<ReservedSize> reservedSizes;
    public static final JsonpDeserializer<ClusterInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterInfo::setupClusterInfoDeserializer, Builder::build);

    public ClusterInfo(Builder builder) {
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
        this.shardSizes = ModelTypeHelper.unmodifiableNonNull(builder.shardSizes, "shard_sizes");
        this.shardDataSetSizes = ModelTypeHelper.unmodifiable(builder.shardDataSetSizes);
        this.shardPaths = ModelTypeHelper.unmodifiableNonNull(builder.shardPaths, "shard_paths");
        this.reservedSizes = ModelTypeHelper.unmodifiableNonNull(builder.reservedSizes, "reserved_sizes");
    }

    public ClusterInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, NodeDiskUsage> nodes() {
        return this.nodes;
    }

    public Map<String, Long> shardSizes() {
        return this.shardSizes;
    }

    @Nullable
    public Map<String, String> shardDataSetSizes() {
        return this.shardDataSetSizes;
    }

    public Map<String, String> shardPaths() {
        return this.shardPaths;
    }

    public List<ReservedSize> reservedSizes() {
        return this.reservedSizes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, NodeDiskUsage> entry : this.nodes.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("shard_sizes");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.shardSizes.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(((Long)entry.getValue()).longValue());
        }
        generator.writeEnd();
        if (this.shardDataSetSizes != null) {
            generator.writeKey("shard_data_set_sizes");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.shardDataSetSizes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("shard_paths");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.shardPaths.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("reserved_sizes");
        generator.writeStartArray();
        for (ReservedSize reservedSize : this.reservedSizes) {
            reservedSize.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupClusterInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeDiskUsage._DESERIALIZER), "nodes", new String[0]);
        op.add(Builder::shardSizes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "shard_sizes", new String[0]);
        op.add(Builder::shardDataSetSizes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "shard_data_set_sizes", new String[0]);
        op.add(Builder::shardPaths, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "shard_paths", new String[0]);
        op.add(Builder::reservedSizes, JsonpDeserializer.arrayDeserializer(ReservedSize._DESERIALIZER), "reserved_sizes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterInfo> {
        private Map<String, NodeDiskUsage> nodes;
        private Map<String, Long> shardSizes;
        @Nullable
        private Map<String, String> shardDataSetSizes;
        private Map<String, String> shardPaths;
        private List<ReservedSize> reservedSizes;

        public Builder nodes(Map<String, NodeDiskUsage> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, NodeDiskUsage value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, NodeDiskUsage>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<NodeDiskUsage.Builder, ObjectBuilder<NodeDiskUsage>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new NodeDiskUsage.Builder()).build()));
        }

        public Builder putNodes(String key, Function<NodeDiskUsage.Builder, ObjectBuilder<NodeDiskUsage>> fn) {
            return this.putNodes(key, fn.apply(new NodeDiskUsage.Builder()).build());
        }

        public Builder shardSizes(Map<String, Long> value) {
            this.shardSizes = value;
            return this;
        }

        public Builder putShardSizes(String key, Long value) {
            if (this.shardSizes == null) {
                this.shardSizes = new HashMap<String, Long>();
            }
            this.shardSizes.put(key, value);
            return this;
        }

        public Builder shardDataSetSizes(@Nullable Map<String, String> value) {
            this.shardDataSetSizes = value;
            return this;
        }

        public Builder putShardDataSetSizes(String key, String value) {
            if (this.shardDataSetSizes == null) {
                this.shardDataSetSizes = new HashMap<String, String>();
            }
            this.shardDataSetSizes.put(key, value);
            return this;
        }

        public Builder shardPaths(Map<String, String> value) {
            this.shardPaths = value;
            return this;
        }

        public Builder putShardPaths(String key, String value) {
            if (this.shardPaths == null) {
                this.shardPaths = new HashMap<String, String>();
            }
            this.shardPaths.put(key, value);
            return this;
        }

        public Builder reservedSizes(List<ReservedSize> value) {
            this.reservedSizes = value;
            return this;
        }

        public Builder reservedSizes(ReservedSize ... value) {
            this.reservedSizes = Arrays.asList(value);
            return this;
        }

        public Builder addReservedSizes(ReservedSize value) {
            if (this.reservedSizes == null) {
                this.reservedSizes = new ArrayList<ReservedSize>();
            }
            this.reservedSizes.add(value);
            return this;
        }

        public Builder reservedSizes(Function<ReservedSize.Builder, ObjectBuilder<ReservedSize>> fn) {
            return this.reservedSizes(fn.apply(new ReservedSize.Builder()).build());
        }

        public Builder addReservedSizes(Function<ReservedSize.Builder, ObjectBuilder<ReservedSize>> fn) {
            return this.addReservedSizes(fn.apply(new ReservedSize.Builder()).build());
        }

        @Override
        public ClusterInfo build() {
            return new ClusterInfo(this);
        }
    }
}

