/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.health;

import co.elastic.clients.elasticsearch._types.Health;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardHealthStats
implements JsonpSerializable {
    private final int activeShards;
    private final int initializingShards;
    private final boolean primaryActive;
    private final int relocatingShards;
    private final Health status;
    private final int unassignedShards;
    public static final JsonpDeserializer<ShardHealthStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardHealthStats::setupShardHealthStatsDeserializer, Builder::build);

    public ShardHealthStats(Builder builder) {
        this.activeShards = Objects.requireNonNull(builder.activeShards, "active_shards");
        this.initializingShards = Objects.requireNonNull(builder.initializingShards, "initializing_shards");
        this.primaryActive = Objects.requireNonNull(builder.primaryActive, "primary_active");
        this.relocatingShards = Objects.requireNonNull(builder.relocatingShards, "relocating_shards");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.unassignedShards = Objects.requireNonNull(builder.unassignedShards, "unassigned_shards");
    }

    public ShardHealthStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int activeShards() {
        return this.activeShards;
    }

    public int initializingShards() {
        return this.initializingShards;
    }

    public boolean primaryActive() {
        return this.primaryActive;
    }

    public int relocatingShards() {
        return this.relocatingShards;
    }

    public Health status() {
        return this.status;
    }

    public int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("primary_active");
        generator.write(this.primaryActive);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    protected static void setupShardHealthStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards", new String[0]);
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards", new String[0]);
        op.add(Builder::primaryActive, JsonpDeserializer.booleanDeserializer(), "primary_active", new String[0]);
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards", new String[0]);
        op.add(Builder::status, Health._DESERIALIZER, "status", new String[0]);
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardHealthStats> {
        private Integer activeShards;
        private Integer initializingShards;
        private Boolean primaryActive;
        private Integer relocatingShards;
        private Health status;
        private Integer unassignedShards;

        public Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        public Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        public Builder primaryActive(boolean value) {
            this.primaryActive = value;
            return this;
        }

        public Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        public Builder status(Health value) {
            this.status = value;
            return this;
        }

        public Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        public ShardHealthStats build() {
            return new ShardHealthStats(this);
        }
    }
}

