/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CommandMoveAction
implements JsonpSerializable {
    private final String index;
    private final int shard;
    private final String fromNode;
    private final String toNode;
    public static final JsonpDeserializer<CommandMoveAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CommandMoveAction::setupCommandMoveActionDeserializer, Builder::build);

    public CommandMoveAction(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.shard = Objects.requireNonNull(builder.shard, "shard");
        this.fromNode = Objects.requireNonNull(builder.fromNode, "from_node");
        this.toNode = Objects.requireNonNull(builder.toNode, "to_node");
    }

    public CommandMoveAction(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public int shard() {
        return this.shard;
    }

    public String fromNode() {
        return this.fromNode;
    }

    public String toNode() {
        return this.toNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("shard");
        generator.write(this.shard);
        generator.writeKey("from_node");
        generator.write(this.fromNode);
        generator.writeKey("to_node");
        generator.write(this.toNode);
    }

    protected static void setupCommandMoveActionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard", new String[0]);
        op.add(Builder::fromNode, JsonpDeserializer.stringDeserializer(), "from_node", new String[0]);
        op.add(Builder::toNode, JsonpDeserializer.stringDeserializer(), "to_node", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CommandMoveAction> {
        private String index;
        private Integer shard;
        private String fromNode;
        private String toNode;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public Builder fromNode(String value) {
            this.fromNode = value;
            return this;
        }

        public Builder toNode(String value) {
            this.toNode = value;
            return this;
        }

        @Override
        public CommandMoveAction build() {
            return new CommandMoveAction(this);
        }
    }
}

