/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.graph.ExploreControls;
import co.elastic.clients.elasticsearch.graph.ExploreResponse;
import co.elastic.clients.elasticsearch.graph.Hop;
import co.elastic.clients.elasticsearch.graph.VertexDefinition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExploreRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final String routing;
    @Nullable
    private final String timeout;
    @Nullable
    private final Hop connections;
    @Nullable
    private final ExploreControls controls;
    @Nullable
    private final Query query;
    @Nullable
    private final List<VertexDefinition> vertices;
    public static final JsonpDeserializer<ExploreRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExploreRequest::setupExploreRequestDeserializer, Builder::build);
    public static final Endpoint<ExploreRequest, ExploreResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ExploreRequest, ExploreResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_graph");
            buf.append("/explore");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_graph");
            buf.append("/explore");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ExploreResponse._DESERIALIZER);

    public ExploreRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.connections = builder.connections;
        this.controls = builder.controls;
        this.query = builder.query;
        this.vertices = ModelTypeHelper.unmodifiable(builder.vertices);
    }

    public ExploreRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Hop connections() {
        return this.connections;
    }

    @Nullable
    public ExploreControls controls() {
        return this.controls;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public List<VertexDefinition> vertices() {
        return this.vertices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connections != null) {
            generator.writeKey("connections");
            this.connections.serialize(generator, mapper);
        }
        if (this.controls != null) {
            generator.writeKey("controls");
            this.controls.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.vertices != null) {
            generator.writeKey("vertices");
            generator.writeStartArray();
            for (VertexDefinition item0 : this.vertices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupExploreRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::connections, Hop._DESERIALIZER, "connections", new String[0]);
        op.add(Builder::controls, ExploreControls._DESERIALIZER, "controls", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::vertices, JsonpDeserializer.arrayDeserializer(VertexDefinition._DESERIALIZER), "vertices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExploreRequest> {
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private String routing;
        @Nullable
        private String timeout;
        @Nullable
        private Hop connections;
        @Nullable
        private ExploreControls controls;
        @Nullable
        private Query query;
        @Nullable
        private List<VertexDefinition> vertices;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder connections(@Nullable Hop value) {
            this.connections = value;
            return this;
        }

        public Builder connections(Function<Hop.Builder, ObjectBuilder<Hop>> fn) {
            return this.connections(fn.apply(new Hop.Builder()).build());
        }

        public Builder controls(@Nullable ExploreControls value) {
            this.controls = value;
            return this;
        }

        public Builder controls(Function<ExploreControls.Builder, ObjectBuilder<ExploreControls>> fn) {
            return this.controls(fn.apply(new ExploreControls.Builder()).build());
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder vertices(@Nullable List<VertexDefinition> value) {
            this.vertices = value;
            return this;
        }

        public Builder vertices(VertexDefinition ... value) {
            this.vertices = Arrays.asList(value);
            return this;
        }

        public Builder addVertices(VertexDefinition value) {
            if (this.vertices == null) {
                this.vertices = new ArrayList<VertexDefinition>();
            }
            this.vertices.add(value);
            return this;
        }

        public Builder vertices(Function<VertexDefinition.Builder, ObjectBuilder<VertexDefinition>> fn) {
            return this.vertices(fn.apply(new VertexDefinition.Builder()).build());
        }

        public Builder addVertices(Function<VertexDefinition.Builder, ObjectBuilder<VertexDefinition>> fn) {
            return this.addVertices(fn.apply(new VertexDefinition.Builder()).build());
        }

        @Override
        public ExploreRequest build() {
            return new ExploreRequest(this);
        }
    }
}

