/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ExistsTypeRequest
extends RequestBase {
    private final List<String> index;
    private final List<String> type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean local;
    public static final Endpoint<ExistsTypeRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<ExistsTypeRequest>(request -> "HEAD", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<ExistsTypeRequest, Map<String, String>>)((Function<ExistsTypeRequest, Map>)request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }), (Function<ExistsTypeRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), false, null);

    public ExistsTypeRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.type = ModelTypeHelper.unmodifiableNonNull(builder.type, "type");
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.local = builder.local;
    }

    public ExistsTypeRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    public static class Builder
    implements ObjectBuilder<ExistsTypeRequest> {
        private List<String> index;
        private List<String> type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean local;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Override
        public ExistsTypeRequest build() {
            return new ExistsTypeRequest(this);
        }
    }
}

