/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.GetDataStreamResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetDataStreamRequest
extends RequestBase {
    @Nullable
    private final List<String> name;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    public static final Endpoint<GetDataStreamRequest, GetDataStreamResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetDataStreamRequest, GetDataStreamResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDataStreamResponse._DESERIALIZER);

    public GetDataStreamRequest(Builder builder) {
        this.name = ModelTypeHelper.unmodifiable(builder.name);
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
    }

    public GetDataStreamRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> name() {
        return this.name;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    public static class Builder
    implements ObjectBuilder<GetDataStreamRequest> {
        @Nullable
        private List<String> name;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;

        public Builder name(@Nullable List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        @Override
        public GetDataStreamRequest build() {
            return new GetDataStreamRequest(this);
        }
    }
}

