/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.RecoveryResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class RecoveryRequest
extends RequestBase {
    @Nullable
    private final List<String> index;
    @Nullable
    private final Boolean activeOnly;
    @Nullable
    private final Boolean detailed;
    public static final Endpoint<RecoveryRequest, RecoveryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RecoveryRequest, RecoveryResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_recovery");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_recovery");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.activeOnly != null) {
            params.put("active_only", String.valueOf(request.activeOnly));
        }
        if (request.detailed != null) {
            params.put("detailed", String.valueOf(request.detailed));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, RecoveryResponse._DESERIALIZER);

    public RecoveryRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.activeOnly = builder.activeOnly;
        this.detailed = builder.detailed;
    }

    public RecoveryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Boolean activeOnly() {
        return this.activeOnly;
    }

    @Nullable
    public Boolean detailed() {
        return this.detailed;
    }

    public static class Builder
    implements ObjectBuilder<RecoveryRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean activeOnly;
        @Nullable
        private Boolean detailed;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder activeOnly(@Nullable Boolean value) {
            this.activeOnly = value;
            return this;
        }

        public Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        @Override
        public RecoveryRequest build() {
            return new RecoveryRequest(this);
        }
    }
}

