/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.put_index_template;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexTemplateMapping
implements JsonpSerializable {
    @Nullable
    private final Map<String, Alias> aliases;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final IndexSettings settings;
    public static final JsonpDeserializer<IndexTemplateMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplateMapping::setupIndexTemplateMappingDeserializer, Builder::build);

    public IndexTemplateMapping(Builder builder) {
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
        this.mappings = builder.mappings;
        this.settings = builder.settings;
    }

    public IndexTemplateMapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public IndexSettings settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, Alias> item0 : this.aliases.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
    }

    protected static void setupIndexTemplateMappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexTemplateMapping> {
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private IndexSettings settings;

        public Builder aliases(@Nullable Map<String, Alias> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, Alias value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, Alias>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new Alias.Builder()).build()));
        }

        public Builder putAliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.putAliases(key, fn.apply(new Alias.Builder()).build());
        }

        public Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder settings(@Nullable IndexSettings value) {
            this.settings = value;
            return this;
        }

        public Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        @Override
        public IndexTemplateMapping build() {
            return new IndexTemplateMapping(this);
        }
    }
}

