/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RecoveryBytes
implements JsonpSerializable {
    private final String percent;
    @Nullable
    private final String recovered;
    private final String recoveredInBytes;
    @Nullable
    private final String recoveredFromSnapshot;
    @Nullable
    private final String recoveredFromSnapshotInBytes;
    @Nullable
    private final String reused;
    private final String reusedInBytes;
    @Nullable
    private final String total;
    private final String totalInBytes;
    public static final JsonpDeserializer<RecoveryBytes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryBytes::setupRecoveryBytesDeserializer, Builder::build);

    public RecoveryBytes(Builder builder) {
        this.percent = Objects.requireNonNull(builder.percent, "percent");
        this.recovered = builder.recovered;
        this.recoveredInBytes = Objects.requireNonNull(builder.recoveredInBytes, "recovered_in_bytes");
        this.recoveredFromSnapshot = builder.recoveredFromSnapshot;
        this.recoveredFromSnapshotInBytes = builder.recoveredFromSnapshotInBytes;
        this.reused = builder.reused;
        this.reusedInBytes = Objects.requireNonNull(builder.reusedInBytes, "reused_in_bytes");
        this.total = builder.total;
        this.totalInBytes = Objects.requireNonNull(builder.totalInBytes, "total_in_bytes");
    }

    public RecoveryBytes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String percent() {
        return this.percent;
    }

    @Nullable
    public String recovered() {
        return this.recovered;
    }

    public String recoveredInBytes() {
        return this.recoveredInBytes;
    }

    @Nullable
    public String recoveredFromSnapshot() {
        return this.recoveredFromSnapshot;
    }

    @Nullable
    public String recoveredFromSnapshotInBytes() {
        return this.recoveredFromSnapshotInBytes;
    }

    @Nullable
    public String reused() {
        return this.reused;
    }

    public String reusedInBytes() {
        return this.reusedInBytes;
    }

    @Nullable
    public String total() {
        return this.total;
    }

    public String totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        if (this.recovered != null) {
            generator.writeKey("recovered");
            generator.write(this.recovered);
        }
        generator.writeKey("recovered_in_bytes");
        generator.write(this.recoveredInBytes);
        if (this.recoveredFromSnapshot != null) {
            generator.writeKey("recovered_from_snapshot");
            generator.write(this.recoveredFromSnapshot);
        }
        if (this.recoveredFromSnapshotInBytes != null) {
            generator.writeKey("recovered_from_snapshot_in_bytes");
            generator.write(this.recoveredFromSnapshotInBytes);
        }
        if (this.reused != null) {
            generator.writeKey("reused");
            generator.write(this.reused);
        }
        generator.writeKey("reused_in_bytes");
        generator.write(this.reusedInBytes);
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupRecoveryBytesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent", new String[0]);
        op.add(Builder::recovered, JsonpDeserializer.stringDeserializer(), "recovered", new String[0]);
        op.add(Builder::recoveredInBytes, JsonpDeserializer.stringDeserializer(), "recovered_in_bytes", new String[0]);
        op.add(Builder::recoveredFromSnapshot, JsonpDeserializer.stringDeserializer(), "recovered_from_snapshot", new String[0]);
        op.add(Builder::recoveredFromSnapshotInBytes, JsonpDeserializer.stringDeserializer(), "recovered_from_snapshot_in_bytes", new String[0]);
        op.add(Builder::reused, JsonpDeserializer.stringDeserializer(), "reused", new String[0]);
        op.add(Builder::reusedInBytes, JsonpDeserializer.stringDeserializer(), "reused_in_bytes", new String[0]);
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total", new String[0]);
        op.add(Builder::totalInBytes, JsonpDeserializer.stringDeserializer(), "total_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RecoveryBytes> {
        private String percent;
        @Nullable
        private String recovered;
        private String recoveredInBytes;
        @Nullable
        private String recoveredFromSnapshot;
        @Nullable
        private String recoveredFromSnapshotInBytes;
        @Nullable
        private String reused;
        private String reusedInBytes;
        @Nullable
        private String total;
        private String totalInBytes;

        public Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public Builder recovered(@Nullable String value) {
            this.recovered = value;
            return this;
        }

        public Builder recoveredInBytes(String value) {
            this.recoveredInBytes = value;
            return this;
        }

        public Builder recoveredFromSnapshot(@Nullable String value) {
            this.recoveredFromSnapshot = value;
            return this;
        }

        public Builder recoveredFromSnapshotInBytes(@Nullable String value) {
            this.recoveredFromSnapshotInBytes = value;
            return this;
        }

        public Builder reused(@Nullable String value) {
            this.reused = value;
            return this;
        }

        public Builder reusedInBytes(String value) {
            this.reusedInBytes = value;
            return this;
        }

        public Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public Builder totalInBytes(String value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public RecoveryBytes build() {
            return new RecoveryBytes(this);
        }
    }
}

