/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TranslogStatus
implements JsonpSerializable {
    private final String percent;
    private final long recovered;
    private final long total;
    private final long totalOnStart;
    @Nullable
    private final String totalTime;
    private final String totalTimeInMillis;
    public static final JsonpDeserializer<TranslogStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogStatus::setupTranslogStatusDeserializer, Builder::build);

    public TranslogStatus(Builder builder) {
        this.percent = Objects.requireNonNull(builder.percent, "percent");
        this.recovered = Objects.requireNonNull(builder.recovered, "recovered");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalOnStart = Objects.requireNonNull(builder.totalOnStart, "total_on_start");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
    }

    public TranslogStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String percent() {
        return this.percent;
    }

    public long recovered() {
        return this.recovered;
    }

    public long total() {
        return this.total;
    }

    public long totalOnStart() {
        return this.totalOnStart;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    public String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_on_start");
        generator.write(this.totalOnStart);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupTranslogStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent", new String[0]);
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::totalOnStart, JsonpDeserializer.longDeserializer(), "total_on_start", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TranslogStatus> {
        private String percent;
        private Long recovered;
        private Long total;
        private Long totalOnStart;
        @Nullable
        private String totalTime;
        private String totalTimeInMillis;

        public Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder totalOnStart(long value) {
            this.totalOnStart = value;
            return this;
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public TranslogStatus build() {
            return new TranslogStatus(this);
        }
    }
}

