/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.reload_search_analyzers;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ReloadDetails
implements JsonpSerializable {
    private final String index;
    private final List<String> reloadedAnalyzers;
    private final List<String> reloadedNodeIds;
    public static final JsonpDeserializer<ReloadDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadDetails::setupReloadDetailsDeserializer, Builder::build);

    public ReloadDetails(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.reloadedAnalyzers = ModelTypeHelper.unmodifiableNonNull(builder.reloadedAnalyzers, "reloaded_analyzers");
        this.reloadedNodeIds = ModelTypeHelper.unmodifiableNonNull(builder.reloadedNodeIds, "reloaded_node_ids");
    }

    public ReloadDetails(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public List<String> reloadedAnalyzers() {
        return this.reloadedAnalyzers;
    }

    public List<String> reloadedNodeIds() {
        return this.reloadedNodeIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("reloaded_analyzers");
        generator.writeStartArray();
        for (String item0 : this.reloadedAnalyzers) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("reloaded_node_ids");
        generator.writeStartArray();
        for (String item0 : this.reloadedNodeIds) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupReloadDetailsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::reloadedAnalyzers, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "reloaded_analyzers", new String[0]);
        op.add(Builder::reloadedNodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "reloaded_node_ids", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReloadDetails> {
        private String index;
        private List<String> reloadedAnalyzers;
        private List<String> reloadedNodeIds;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder reloadedAnalyzers(List<String> value) {
            this.reloadedAnalyzers = value;
            return this;
        }

        public Builder reloadedAnalyzers(String ... value) {
            this.reloadedAnalyzers = Arrays.asList(value);
            return this;
        }

        public Builder addReloadedAnalyzers(String value) {
            if (this.reloadedAnalyzers == null) {
                this.reloadedAnalyzers = new ArrayList<String>();
            }
            this.reloadedAnalyzers.add(value);
            return this;
        }

        public Builder reloadedNodeIds(List<String> value) {
            this.reloadedNodeIds = value;
            return this;
        }

        public Builder reloadedNodeIds(String ... value) {
            this.reloadedNodeIds = Arrays.asList(value);
            return this;
        }

        public Builder addReloadedNodeIds(String value) {
            if (this.reloadedNodeIds == null) {
                this.reloadedNodeIds = new ArrayList<String>();
            }
            this.reloadedNodeIds.add(value);
            return this;
        }

        @Override
        public ReloadDetails build() {
            return new ReloadDetails(this);
        }
    }
}

