/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardStoreException
implements JsonpSerializable {
    private final String reason;
    private final String type;
    public static final JsonpDeserializer<ShardStoreException> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreException::setupShardStoreExceptionDeserializer, Builder::build);

    public ShardStoreException(Builder builder) {
        this.reason = Objects.requireNonNull(builder.reason, "reason");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public ShardStoreException(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String reason() {
        return this.reason;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupShardStoreExceptionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStoreException> {
        private String reason;
        private String type;

        public Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public ShardStoreException build() {
            return new ShardStoreException(this);
        }
    }
}

