/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.DateRounding;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DateIndexNameProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final List<String> dateFormats;
    private final DateRounding dateRounding;
    private final String field;
    private final String indexNameFormat;
    private final String indexNamePrefix;
    private final String locale;
    private final String timezone;
    public static final JsonpDeserializer<DateIndexNameProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateIndexNameProcessor::setupDateIndexNameProcessorDeserializer, Builder::build);

    public DateIndexNameProcessor(Builder builder) {
        super(builder);
        this.dateFormats = ModelTypeHelper.unmodifiableNonNull(builder.dateFormats, "date_formats");
        this.dateRounding = Objects.requireNonNull(builder.dateRounding, "date_rounding");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.indexNameFormat = Objects.requireNonNull(builder.indexNameFormat, "index_name_format");
        this.indexNamePrefix = Objects.requireNonNull(builder.indexNamePrefix, "index_name_prefix");
        this.locale = Objects.requireNonNull(builder.locale, "locale");
        this.timezone = Objects.requireNonNull(builder.timezone, "timezone");
    }

    public DateIndexNameProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "date_index_name";
    }

    public List<String> dateFormats() {
        return this.dateFormats;
    }

    public DateRounding dateRounding() {
        return this.dateRounding;
    }

    public String field() {
        return this.field;
    }

    public String indexNameFormat() {
        return this.indexNameFormat;
    }

    public String indexNamePrefix() {
        return this.indexNamePrefix;
    }

    public String locale() {
        return this.locale;
    }

    public String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("date_formats");
        generator.writeStartArray();
        for (String item0 : this.dateFormats) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("date_rounding");
        this.dateRounding.serialize(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("index_name_format");
        generator.write(this.indexNameFormat);
        generator.writeKey("index_name_prefix");
        generator.write(this.indexNamePrefix);
        generator.writeKey("locale");
        generator.write(this.locale);
        generator.writeKey("timezone");
        generator.write(this.timezone);
    }

    protected static void setupDateIndexNameProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::dateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "date_formats", new String[0]);
        op.add(Builder::dateRounding, DateRounding._DESERIALIZER, "date_rounding", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::indexNameFormat, JsonpDeserializer.stringDeserializer(), "index_name_format", new String[0]);
        op.add(Builder::indexNamePrefix, JsonpDeserializer.stringDeserializer(), "index_name_prefix", new String[0]);
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale", new String[0]);
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateIndexNameProcessor> {
        private List<String> dateFormats;
        private DateRounding dateRounding;
        private String field;
        private String indexNameFormat;
        private String indexNamePrefix;
        private String locale;
        private String timezone;

        public Builder dateFormats(List<String> value) {
            this.dateFormats = value;
            return this;
        }

        public Builder dateFormats(String ... value) {
            this.dateFormats = Arrays.asList(value);
            return this;
        }

        public Builder addDateFormats(String value) {
            if (this.dateFormats == null) {
                this.dateFormats = new ArrayList<String>();
            }
            this.dateFormats.add(value);
            return this;
        }

        public Builder dateRounding(DateRounding value) {
            this.dateRounding = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder indexNameFormat(String value) {
            this.indexNameFormat = value;
            return this;
        }

        public Builder indexNamePrefix(String value) {
            this.indexNamePrefix = value;
            return this;
        }

        public Builder locale(String value) {
            this.locale = value;
            return this;
        }

        public Builder timezone(String value) {
            this.timezone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateIndexNameProcessor build() {
            return new DateIndexNameProcessor(this);
        }
    }
}

