/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.AppendProcessor;
import co.elastic.clients.elasticsearch.ingest.AttachmentProcessor;
import co.elastic.clients.elasticsearch.ingest.BytesProcessor;
import co.elastic.clients.elasticsearch.ingest.CircleProcessor;
import co.elastic.clients.elasticsearch.ingest.ConvertProcessor;
import co.elastic.clients.elasticsearch.ingest.CsvProcessor;
import co.elastic.clients.elasticsearch.ingest.DateIndexNameProcessor;
import co.elastic.clients.elasticsearch.ingest.DateProcessor;
import co.elastic.clients.elasticsearch.ingest.DissectProcessor;
import co.elastic.clients.elasticsearch.ingest.DotExpanderProcessor;
import co.elastic.clients.elasticsearch.ingest.DropProcessor;
import co.elastic.clients.elasticsearch.ingest.EnrichProcessor;
import co.elastic.clients.elasticsearch.ingest.FailProcessor;
import co.elastic.clients.elasticsearch.ingest.ForeachProcessor;
import co.elastic.clients.elasticsearch.ingest.GeoIpProcessor;
import co.elastic.clients.elasticsearch.ingest.GrokProcessor;
import co.elastic.clients.elasticsearch.ingest.GsubProcessor;
import co.elastic.clients.elasticsearch.ingest.InferenceProcessor;
import co.elastic.clients.elasticsearch.ingest.JoinProcessor;
import co.elastic.clients.elasticsearch.ingest.JsonProcessor;
import co.elastic.clients.elasticsearch.ingest.KeyValueProcessor;
import co.elastic.clients.elasticsearch.ingest.LowercaseProcessor;
import co.elastic.clients.elasticsearch.ingest.PipelineProcessor;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.RemoveProcessor;
import co.elastic.clients.elasticsearch.ingest.RenameProcessor;
import co.elastic.clients.elasticsearch.ingest.SetProcessor;
import co.elastic.clients.elasticsearch.ingest.SetSecurityUserProcessor;
import co.elastic.clients.elasticsearch.ingest.SortProcessor;
import co.elastic.clients.elasticsearch.ingest.SplitProcessor;
import co.elastic.clients.elasticsearch.ingest.TrimProcessor;
import co.elastic.clients.elasticsearch.ingest.UppercaseProcessor;
import co.elastic.clients.elasticsearch.ingest.UrlDecodeProcessor;
import co.elastic.clients.elasticsearch.ingest.UserAgentProcessor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Processor
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String ATTACHMENT = "attachment";
    public static final String APPEND = "append";
    public static final String CSV = "csv";
    public static final String CONVERT = "convert";
    public static final String DATE = "date";
    public static final String DATE_INDEX_NAME = "date_index_name";
    public static final String DOT_EXPANDER = "dot_expander";
    public static final String ENRICH = "enrich";
    public static final String FAIL = "fail";
    public static final String FOREACH = "foreach";
    public static final String JSON = "json";
    public static final String USER_AGENT = "user_agent";
    public static final String KV = "kv";
    public static final String GEOIP = "geoip";
    public static final String GROK = "grok";
    public static final String GSUB = "gsub";
    public static final String JOIN = "join";
    public static final String LOWERCASE = "lowercase";
    public static final String REMOVE = "remove";
    public static final String RENAME = "rename";
    public static final String SCRIPT = "script";
    public static final String SET = "set";
    public static final String SORT = "sort";
    public static final String SPLIT = "split";
    public static final String TRIM = "trim";
    public static final String UPPERCASE = "uppercase";
    public static final String URLDECODE = "urldecode";
    public static final String BYTES = "bytes";
    public static final String DISSECT = "dissect";
    public static final String SET_SECURITY_USER = "set_security_user";
    public static final String PIPELINE = "pipeline";
    public static final String DROP = "drop";
    public static final String CIRCLE = "circle";
    public static final String INFERENCE = "inference";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Processor> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Processor::setupProcessorDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Processor(ProcessorVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Processor(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Processor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AttachmentProcessor attachment() {
        return (AttachmentProcessor)TaggedUnionUtils.get(this, ATTACHMENT);
    }

    public AppendProcessor append() {
        return (AppendProcessor)TaggedUnionUtils.get(this, APPEND);
    }

    public CsvProcessor csv() {
        return (CsvProcessor)TaggedUnionUtils.get(this, CSV);
    }

    public ConvertProcessor convert() {
        return (ConvertProcessor)TaggedUnionUtils.get(this, CONVERT);
    }

    public DateProcessor date() {
        return (DateProcessor)TaggedUnionUtils.get(this, DATE);
    }

    public DateIndexNameProcessor dateIndexName() {
        return (DateIndexNameProcessor)TaggedUnionUtils.get(this, DATE_INDEX_NAME);
    }

    public DotExpanderProcessor dotExpander() {
        return (DotExpanderProcessor)TaggedUnionUtils.get(this, DOT_EXPANDER);
    }

    public EnrichProcessor enrich() {
        return (EnrichProcessor)TaggedUnionUtils.get(this, ENRICH);
    }

    public FailProcessor fail() {
        return (FailProcessor)TaggedUnionUtils.get(this, FAIL);
    }

    public ForeachProcessor foreach() {
        return (ForeachProcessor)TaggedUnionUtils.get(this, FOREACH);
    }

    public JsonProcessor json() {
        return (JsonProcessor)TaggedUnionUtils.get(this, JSON);
    }

    public UserAgentProcessor userAgent() {
        return (UserAgentProcessor)TaggedUnionUtils.get(this, USER_AGENT);
    }

    public KeyValueProcessor kv() {
        return (KeyValueProcessor)TaggedUnionUtils.get(this, KV);
    }

    public GeoIpProcessor geoip() {
        return (GeoIpProcessor)TaggedUnionUtils.get(this, GEOIP);
    }

    public GrokProcessor grok() {
        return (GrokProcessor)TaggedUnionUtils.get(this, GROK);
    }

    public GsubProcessor gsub() {
        return (GsubProcessor)TaggedUnionUtils.get(this, GSUB);
    }

    public JoinProcessor join() {
        return (JoinProcessor)TaggedUnionUtils.get(this, JOIN);
    }

    public LowercaseProcessor lowercase() {
        return (LowercaseProcessor)TaggedUnionUtils.get(this, LOWERCASE);
    }

    public RemoveProcessor remove() {
        return (RemoveProcessor)TaggedUnionUtils.get(this, REMOVE);
    }

    public RenameProcessor rename() {
        return (RenameProcessor)TaggedUnionUtils.get(this, RENAME);
    }

    public JsonValue script() {
        return (JsonValue)TaggedUnionUtils.get(this, SCRIPT);
    }

    public SetProcessor set() {
        return (SetProcessor)TaggedUnionUtils.get(this, SET);
    }

    public SortProcessor sort() {
        return (SortProcessor)TaggedUnionUtils.get(this, SORT);
    }

    public SplitProcessor split() {
        return (SplitProcessor)TaggedUnionUtils.get(this, SPLIT);
    }

    public TrimProcessor trim() {
        return (TrimProcessor)TaggedUnionUtils.get(this, TRIM);
    }

    public UppercaseProcessor uppercase() {
        return (UppercaseProcessor)TaggedUnionUtils.get(this, UPPERCASE);
    }

    public UrlDecodeProcessor urldecode() {
        return (UrlDecodeProcessor)TaggedUnionUtils.get(this, URLDECODE);
    }

    public BytesProcessor bytes() {
        return (BytesProcessor)TaggedUnionUtils.get(this, BYTES);
    }

    public DissectProcessor dissect() {
        return (DissectProcessor)TaggedUnionUtils.get(this, DISSECT);
    }

    public SetSecurityUserProcessor setSecurityUser() {
        return (SetSecurityUserProcessor)TaggedUnionUtils.get(this, SET_SECURITY_USER);
    }

    public PipelineProcessor pipeline() {
        return (PipelineProcessor)TaggedUnionUtils.get(this, PIPELINE);
    }

    public DropProcessor drop() {
        return (DropProcessor)TaggedUnionUtils.get(this, DROP);
    }

    public CircleProcessor circle() {
        return (CircleProcessor)TaggedUnionUtils.get(this, CIRCLE);
    }

    public InferenceProcessor inference() {
        return (InferenceProcessor)TaggedUnionUtils.get(this, INFERENCE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "script": {
                    generator.write((JsonValue)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::attachment, AttachmentProcessor._DESERIALIZER, ATTACHMENT, new String[0]);
        op.add(Builder::append, AppendProcessor._DESERIALIZER, APPEND, new String[0]);
        op.add(Builder::csv, CsvProcessor._DESERIALIZER, CSV, new String[0]);
        op.add(Builder::convert, ConvertProcessor._DESERIALIZER, CONVERT, new String[0]);
        op.add(Builder::date, DateProcessor._DESERIALIZER, DATE, new String[0]);
        op.add(Builder::dateIndexName, DateIndexNameProcessor._DESERIALIZER, DATE_INDEX_NAME, new String[0]);
        op.add(Builder::dotExpander, DotExpanderProcessor._DESERIALIZER, DOT_EXPANDER, new String[0]);
        op.add(Builder::enrich, EnrichProcessor._DESERIALIZER, ENRICH, new String[0]);
        op.add(Builder::fail, FailProcessor._DESERIALIZER, FAIL, new String[0]);
        op.add(Builder::foreach, ForeachProcessor._DESERIALIZER, FOREACH, new String[0]);
        op.add(Builder::json, JsonProcessor._DESERIALIZER, JSON, new String[0]);
        op.add(Builder::userAgent, UserAgentProcessor._DESERIALIZER, USER_AGENT, new String[0]);
        op.add(Builder::kv, KeyValueProcessor._DESERIALIZER, KV, new String[0]);
        op.add(Builder::geoip, GeoIpProcessor._DESERIALIZER, GEOIP, new String[0]);
        op.add(Builder::grok, GrokProcessor._DESERIALIZER, GROK, new String[0]);
        op.add(Builder::gsub, GsubProcessor._DESERIALIZER, GSUB, new String[0]);
        op.add(Builder::join, JoinProcessor._DESERIALIZER, JOIN, new String[0]);
        op.add(Builder::lowercase, LowercaseProcessor._DESERIALIZER, LOWERCASE, new String[0]);
        op.add(Builder::remove, RemoveProcessor._DESERIALIZER, REMOVE, new String[0]);
        op.add(Builder::rename, RenameProcessor._DESERIALIZER, RENAME, new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), SCRIPT, new String[0]);
        op.add(Builder::set, SetProcessor._DESERIALIZER, SET, new String[0]);
        op.add(Builder::sort, SortProcessor._DESERIALIZER, SORT, new String[0]);
        op.add(Builder::split, SplitProcessor._DESERIALIZER, SPLIT, new String[0]);
        op.add(Builder::trim, TrimProcessor._DESERIALIZER, TRIM, new String[0]);
        op.add(Builder::uppercase, UppercaseProcessor._DESERIALIZER, UPPERCASE, new String[0]);
        op.add(Builder::urldecode, UrlDecodeProcessor._DESERIALIZER, URLDECODE, new String[0]);
        op.add(Builder::bytes, BytesProcessor._DESERIALIZER, BYTES, new String[0]);
        op.add(Builder::dissect, DissectProcessor._DESERIALIZER, DISSECT, new String[0]);
        op.add(Builder::setSecurityUser, SetSecurityUserProcessor._DESERIALIZER, SET_SECURITY_USER, new String[0]);
        op.add(Builder::pipeline, PipelineProcessor._DESERIALIZER, PIPELINE, new String[0]);
        op.add(Builder::drop, DropProcessor._DESERIALIZER, DROP, new String[0]);
        op.add(Builder::circle, CircleProcessor._DESERIALIZER, CIRCLE, new String[0]);
        op.add(Builder::inference, InferenceProcessor._DESERIALIZER, INFERENCE, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Processor> {
        private String _type;
        private Object _value;

        public Builder attachment(AttachmentProcessor v) {
            this._type = Processor.ATTACHMENT;
            this._value = v;
            return this;
        }

        public Builder attachment(Function<AttachmentProcessor.Builder, ObjectBuilder<AttachmentProcessor>> f) {
            return this.attachment(f.apply(new AttachmentProcessor.Builder()).build());
        }

        public Builder append(AppendProcessor v) {
            this._type = Processor.APPEND;
            this._value = v;
            return this;
        }

        public Builder append(Function<AppendProcessor.Builder, ObjectBuilder<AppendProcessor>> f) {
            return this.append(f.apply(new AppendProcessor.Builder()).build());
        }

        public Builder csv(CsvProcessor v) {
            this._type = Processor.CSV;
            this._value = v;
            return this;
        }

        public Builder csv(Function<CsvProcessor.Builder, ObjectBuilder<CsvProcessor>> f) {
            return this.csv(f.apply(new CsvProcessor.Builder()).build());
        }

        public Builder convert(ConvertProcessor v) {
            this._type = Processor.CONVERT;
            this._value = v;
            return this;
        }

        public Builder convert(Function<ConvertProcessor.Builder, ObjectBuilder<ConvertProcessor>> f) {
            return this.convert(f.apply(new ConvertProcessor.Builder()).build());
        }

        public Builder date(DateProcessor v) {
            this._type = Processor.DATE;
            this._value = v;
            return this;
        }

        public Builder date(Function<DateProcessor.Builder, ObjectBuilder<DateProcessor>> f) {
            return this.date(f.apply(new DateProcessor.Builder()).build());
        }

        public Builder dateIndexName(DateIndexNameProcessor v) {
            this._type = Processor.DATE_INDEX_NAME;
            this._value = v;
            return this;
        }

        public Builder dateIndexName(Function<DateIndexNameProcessor.Builder, ObjectBuilder<DateIndexNameProcessor>> f) {
            return this.dateIndexName(f.apply(new DateIndexNameProcessor.Builder()).build());
        }

        public Builder dotExpander(DotExpanderProcessor v) {
            this._type = Processor.DOT_EXPANDER;
            this._value = v;
            return this;
        }

        public Builder dotExpander(Function<DotExpanderProcessor.Builder, ObjectBuilder<DotExpanderProcessor>> f) {
            return this.dotExpander(f.apply(new DotExpanderProcessor.Builder()).build());
        }

        public Builder enrich(EnrichProcessor v) {
            this._type = Processor.ENRICH;
            this._value = v;
            return this;
        }

        public Builder enrich(Function<EnrichProcessor.Builder, ObjectBuilder<EnrichProcessor>> f) {
            return this.enrich(f.apply(new EnrichProcessor.Builder()).build());
        }

        public Builder fail(FailProcessor v) {
            this._type = Processor.FAIL;
            this._value = v;
            return this;
        }

        public Builder fail(Function<FailProcessor.Builder, ObjectBuilder<FailProcessor>> f) {
            return this.fail(f.apply(new FailProcessor.Builder()).build());
        }

        public Builder foreach(ForeachProcessor v) {
            this._type = Processor.FOREACH;
            this._value = v;
            return this;
        }

        public Builder foreach(Function<ForeachProcessor.Builder, ObjectBuilder<ForeachProcessor>> f) {
            return this.foreach(f.apply(new ForeachProcessor.Builder()).build());
        }

        public Builder json(JsonProcessor v) {
            this._type = Processor.JSON;
            this._value = v;
            return this;
        }

        public Builder json(Function<JsonProcessor.Builder, ObjectBuilder<JsonProcessor>> f) {
            return this.json(f.apply(new JsonProcessor.Builder()).build());
        }

        public Builder userAgent(UserAgentProcessor v) {
            this._type = Processor.USER_AGENT;
            this._value = v;
            return this;
        }

        public Builder userAgent(Function<UserAgentProcessor.Builder, ObjectBuilder<UserAgentProcessor>> f) {
            return this.userAgent(f.apply(new UserAgentProcessor.Builder()).build());
        }

        public Builder kv(KeyValueProcessor v) {
            this._type = Processor.KV;
            this._value = v;
            return this;
        }

        public Builder kv(Function<KeyValueProcessor.Builder, ObjectBuilder<KeyValueProcessor>> f) {
            return this.kv(f.apply(new KeyValueProcessor.Builder()).build());
        }

        public Builder geoip(GeoIpProcessor v) {
            this._type = Processor.GEOIP;
            this._value = v;
            return this;
        }

        public Builder geoip(Function<GeoIpProcessor.Builder, ObjectBuilder<GeoIpProcessor>> f) {
            return this.geoip(f.apply(new GeoIpProcessor.Builder()).build());
        }

        public Builder grok(GrokProcessor v) {
            this._type = Processor.GROK;
            this._value = v;
            return this;
        }

        public Builder grok(Function<GrokProcessor.Builder, ObjectBuilder<GrokProcessor>> f) {
            return this.grok(f.apply(new GrokProcessor.Builder()).build());
        }

        public Builder gsub(GsubProcessor v) {
            this._type = Processor.GSUB;
            this._value = v;
            return this;
        }

        public Builder gsub(Function<GsubProcessor.Builder, ObjectBuilder<GsubProcessor>> f) {
            return this.gsub(f.apply(new GsubProcessor.Builder()).build());
        }

        public Builder join(JoinProcessor v) {
            this._type = Processor.JOIN;
            this._value = v;
            return this;
        }

        public Builder join(Function<JoinProcessor.Builder, ObjectBuilder<JoinProcessor>> f) {
            return this.join(f.apply(new JoinProcessor.Builder()).build());
        }

        public Builder lowercase(LowercaseProcessor v) {
            this._type = Processor.LOWERCASE;
            this._value = v;
            return this;
        }

        public Builder lowercase(Function<LowercaseProcessor.Builder, ObjectBuilder<LowercaseProcessor>> f) {
            return this.lowercase(f.apply(new LowercaseProcessor.Builder()).build());
        }

        public Builder remove(RemoveProcessor v) {
            this._type = Processor.REMOVE;
            this._value = v;
            return this;
        }

        public Builder remove(Function<RemoveProcessor.Builder, ObjectBuilder<RemoveProcessor>> f) {
            return this.remove(f.apply(new RemoveProcessor.Builder()).build());
        }

        public Builder rename(RenameProcessor v) {
            this._type = Processor.RENAME;
            this._value = v;
            return this;
        }

        public Builder rename(Function<RenameProcessor.Builder, ObjectBuilder<RenameProcessor>> f) {
            return this.rename(f.apply(new RenameProcessor.Builder()).build());
        }

        public Builder script(JsonValue v) {
            this._type = Processor.SCRIPT;
            this._value = v;
            return this;
        }

        public Builder set(SetProcessor v) {
            this._type = Processor.SET;
            this._value = v;
            return this;
        }

        public Builder set(Function<SetProcessor.Builder, ObjectBuilder<SetProcessor>> f) {
            return this.set(f.apply(new SetProcessor.Builder()).build());
        }

        public Builder sort(SortProcessor v) {
            this._type = Processor.SORT;
            this._value = v;
            return this;
        }

        public Builder sort(Function<SortProcessor.Builder, ObjectBuilder<SortProcessor>> f) {
            return this.sort(f.apply(new SortProcessor.Builder()).build());
        }

        public Builder split(SplitProcessor v) {
            this._type = Processor.SPLIT;
            this._value = v;
            return this;
        }

        public Builder split(Function<SplitProcessor.Builder, ObjectBuilder<SplitProcessor>> f) {
            return this.split(f.apply(new SplitProcessor.Builder()).build());
        }

        public Builder trim(TrimProcessor v) {
            this._type = Processor.TRIM;
            this._value = v;
            return this;
        }

        public Builder trim(Function<TrimProcessor.Builder, ObjectBuilder<TrimProcessor>> f) {
            return this.trim(f.apply(new TrimProcessor.Builder()).build());
        }

        public Builder uppercase(UppercaseProcessor v) {
            this._type = Processor.UPPERCASE;
            this._value = v;
            return this;
        }

        public Builder uppercase(Function<UppercaseProcessor.Builder, ObjectBuilder<UppercaseProcessor>> f) {
            return this.uppercase(f.apply(new UppercaseProcessor.Builder()).build());
        }

        public Builder urldecode(UrlDecodeProcessor v) {
            this._type = Processor.URLDECODE;
            this._value = v;
            return this;
        }

        public Builder urldecode(Function<UrlDecodeProcessor.Builder, ObjectBuilder<UrlDecodeProcessor>> f) {
            return this.urldecode(f.apply(new UrlDecodeProcessor.Builder()).build());
        }

        public Builder bytes(BytesProcessor v) {
            this._type = Processor.BYTES;
            this._value = v;
            return this;
        }

        public Builder bytes(Function<BytesProcessor.Builder, ObjectBuilder<BytesProcessor>> f) {
            return this.bytes(f.apply(new BytesProcessor.Builder()).build());
        }

        public Builder dissect(DissectProcessor v) {
            this._type = Processor.DISSECT;
            this._value = v;
            return this;
        }

        public Builder dissect(Function<DissectProcessor.Builder, ObjectBuilder<DissectProcessor>> f) {
            return this.dissect(f.apply(new DissectProcessor.Builder()).build());
        }

        public Builder setSecurityUser(SetSecurityUserProcessor v) {
            this._type = Processor.SET_SECURITY_USER;
            this._value = v;
            return this;
        }

        public Builder setSecurityUser(Function<SetSecurityUserProcessor.Builder, ObjectBuilder<SetSecurityUserProcessor>> f) {
            return this.setSecurityUser(f.apply(new SetSecurityUserProcessor.Builder()).build());
        }

        public Builder pipeline(PipelineProcessor v) {
            this._type = Processor.PIPELINE;
            this._value = v;
            return this;
        }

        public Builder pipeline(Function<PipelineProcessor.Builder, ObjectBuilder<PipelineProcessor>> f) {
            return this.pipeline(f.apply(new PipelineProcessor.Builder()).build());
        }

        public Builder drop(DropProcessor v) {
            this._type = Processor.DROP;
            this._value = v;
            return this;
        }

        public Builder drop(Function<DropProcessor.Builder, ObjectBuilder<DropProcessor>> f) {
            return this.drop(f.apply(new DropProcessor.Builder()).build());
        }

        public Builder circle(CircleProcessor v) {
            this._type = Processor.CIRCLE;
            this._value = v;
            return this;
        }

        public Builder circle(Function<CircleProcessor.Builder, ObjectBuilder<CircleProcessor>> f) {
            return this.circle(f.apply(new CircleProcessor.Builder()).build());
        }

        public Builder inference(InferenceProcessor v) {
            this._type = Processor.INFERENCE;
            this._value = v;
            return this;
        }

        public Builder inference(Function<InferenceProcessor.Builder, ObjectBuilder<InferenceProcessor>> f) {
            return this.inference(f.apply(new InferenceProcessor.Builder()).build());
        }

        @Override
        public Processor build() {
            return new Processor(this);
        }
    }
}

