/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ProcessorBase
implements JsonpSerializable {
    @Nullable
    private final String if_;
    @Nullable
    private final Boolean ignoreFailure;
    @Nullable
    private final List<Processor> onFailure;
    @Nullable
    private final String tag;

    public ProcessorBase(AbstractBuilder<?> builder) {
        this.if_ = ((AbstractBuilder)builder).if_;
        this.ignoreFailure = ((AbstractBuilder)builder).ignoreFailure;
        this.onFailure = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).onFailure);
        this.tag = ((AbstractBuilder)builder).tag;
    }

    @Nullable
    public String if_() {
        return this.if_;
    }

    @Nullable
    public Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nullable
    public List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nullable
    public String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.if_ != null) {
            generator.writeKey("if");
            generator.write(this.if_);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (this.onFailure != null) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor item0 : this.onFailure) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupProcessorBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::if_, JsonpDeserializer.stringDeserializer(), "if", new String[0]);
        op.add(AbstractBuilder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure", new String[0]);
        op.add(AbstractBuilder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure", new String[0]);
        op.add(AbstractBuilder::tag, JsonpDeserializer.stringDeserializer(), "tag", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String if_;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private String tag;

        protected AbstractBuilder() {
        }

        public BuilderT if_(@Nullable String value) {
            this.if_ = value;
            return this.self();
        }

        public BuilderT ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this.self();
        }

        public BuilderT onFailure(@Nullable List<Processor> value) {
            this.onFailure = value;
            return this.self();
        }

        public BuilderT onFailure(Processor ... value) {
            this.onFailure = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addOnFailure(Processor value) {
            if (this.onFailure == null) {
                this.onFailure = new ArrayList<Processor>();
            }
            this.onFailure.add(value);
            return this.self();
        }

        public BuilderT onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build());
        }

        public BuilderT addOnFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.addOnFailure(fn.apply(new Processor.Builder()).build());
        }

        public BuilderT tag(@Nullable String value) {
            this.tag = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

