/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SetProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean override;
    private final JsonData value;
    public static final JsonpDeserializer<SetProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SetProcessor::setupSetProcessorDeserializer, Builder::build);

    public SetProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.override = builder.override;
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public SetProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "set";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean override() {
        return this.override;
    }

    public JsonData value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.override != null) {
            generator.writeKey("override");
            generator.write(this.override.booleanValue());
        }
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    protected static void setupSetProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::override, JsonpDeserializer.booleanDeserializer(), "override", new String[0]);
        op.add(Builder::value, JsonData._DESERIALIZER, "value", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SetProcessor> {
        private String field;
        @Nullable
        private Boolean override;
        private JsonData value;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder override(@Nullable Boolean value) {
            this.override = value;
            return this;
        }

        public Builder value(JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SetProcessor build() {
            return new SetProcessor(this);
        }
    }
}

