/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.license.License;
import co.elastic.clients.elasticsearch.license.PostResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PostRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean acknowledge;
    @Nullable
    private final License license;
    @Nullable
    private final List<License> licenses;
    public static final JsonpDeserializer<PostRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostRequest::setupPostRequestDeserializer, Builder::build);
    public static final Endpoint<PostRequest, PostResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PostRequest, PostResponse>(request -> "PUT", request -> "/_license", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.acknowledge != null) {
            params.put("acknowledge", String.valueOf(request.acknowledge));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PostResponse._DESERIALIZER);

    public PostRequest(Builder builder) {
        this.acknowledge = builder.acknowledge;
        this.license = builder.license;
        this.licenses = ModelTypeHelper.unmodifiable(builder.licenses);
    }

    public PostRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean acknowledge() {
        return this.acknowledge;
    }

    @Nullable
    public License license() {
        return this.license;
    }

    @Nullable
    public List<License> licenses() {
        return this.licenses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.license != null) {
            generator.writeKey("license");
            this.license.serialize(generator, mapper);
        }
        if (this.licenses != null) {
            generator.writeKey("licenses");
            generator.writeStartArray();
            for (License item0 : this.licenses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPostRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::license, License._DESERIALIZER, "license", new String[0]);
        op.add(Builder::licenses, JsonpDeserializer.arrayDeserializer(License._DESERIALIZER), "licenses", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PostRequest> {
        @Nullable
        private Boolean acknowledge;
        @Nullable
        private License license;
        @Nullable
        private List<License> licenses;

        public Builder acknowledge(@Nullable Boolean value) {
            this.acknowledge = value;
            return this;
        }

        public Builder license(@Nullable License value) {
            this.license = value;
            return this;
        }

        public Builder license(Function<License.Builder, ObjectBuilder<License>> fn) {
            return this.license(fn.apply(new License.Builder()).build());
        }

        public Builder licenses(@Nullable List<License> value) {
            this.licenses = value;
            return this;
        }

        public Builder licenses(License ... value) {
            this.licenses = Arrays.asList(value);
            return this;
        }

        public Builder addLicenses(License value) {
            if (this.licenses == null) {
                this.licenses = new ArrayList<License>();
            }
            this.licenses.add(value);
            return this;
        }

        public Builder licenses(Function<License.Builder, ObjectBuilder<License>> fn) {
            return this.licenses(fn.apply(new License.Builder()).build());
        }

        public Builder addLicenses(Function<License.Builder, ObjectBuilder<License>> fn) {
            return this.addLicenses(fn.apply(new License.Builder()).build());
        }

        @Override
        public PostRequest build() {
            return new PostRequest(this);
        }
    }
}

