/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license.post;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Acknowledgement
implements JsonpSerializable {
    private final List<String> license;
    private final String message;
    public static final JsonpDeserializer<Acknowledgement> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Acknowledgement::setupAcknowledgementDeserializer, Builder::build);

    public Acknowledgement(Builder builder) {
        this.license = ModelTypeHelper.unmodifiableNonNull(builder.license, "license");
        this.message = Objects.requireNonNull(builder.message, "message");
    }

    public Acknowledgement(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> license() {
        return this.license;
    }

    public String message() {
        return this.message;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("license");
        generator.writeStartArray();
        for (String item0 : this.license) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("message");
        generator.write(this.message);
    }

    protected static void setupAcknowledgementDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::license, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "license", new String[0]);
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Acknowledgement> {
        private List<String> license;
        private String message;

        public Builder license(List<String> value) {
            this.license = value;
            return this;
        }

        public Builder license(String ... value) {
            this.license = Arrays.asList(value);
            return this;
        }

        public Builder addLicense(String value) {
            if (this.license == null) {
                this.license = new ArrayList<String>();
            }
            this.license.add(value);
            return this;
        }

        public Builder message(String value) {
            this.message = value;
            return this;
        }

        @Override
        public Acknowledgement build() {
            return new Acknowledgement(this);
        }
    }
}

