/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.elasticsearch.logstash.PipelineMetadata;
import co.elastic.clients.elasticsearch.logstash.PipelineSettings;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Pipeline
implements JsonpSerializable {
    private final String description;
    private final String lastModified;
    private final PipelineMetadata pipelineMetadata;
    private final String username;
    private final String pipeline;
    private final PipelineSettings pipelineSettings;
    public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pipeline::setupPipelineDeserializer, Builder::build);

    public Pipeline(Builder builder) {
        this.description = Objects.requireNonNull(builder.description, "description");
        this.lastModified = Objects.requireNonNull(builder.lastModified, "last_modified");
        this.pipelineMetadata = Objects.requireNonNull(builder.pipelineMetadata, "pipeline_metadata");
        this.username = Objects.requireNonNull(builder.username, "username");
        this.pipeline = Objects.requireNonNull(builder.pipeline, "pipeline");
        this.pipelineSettings = Objects.requireNonNull(builder.pipelineSettings, "pipeline_settings");
    }

    public Pipeline(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String description() {
        return this.description;
    }

    public String lastModified() {
        return this.lastModified;
    }

    public PipelineMetadata pipelineMetadata() {
        return this.pipelineMetadata;
    }

    public String username() {
        return this.username;
    }

    public String pipeline() {
        return this.pipeline;
    }

    public PipelineSettings pipelineSettings() {
        return this.pipelineSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("last_modified");
        generator.write(this.lastModified);
        generator.writeKey("pipeline_metadata");
        this.pipelineMetadata.serialize(generator, mapper);
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("pipeline");
        generator.write(this.pipeline);
        generator.writeKey("pipeline_settings");
        this.pipelineSettings.serialize(generator, mapper);
    }

    protected static void setupPipelineDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::lastModified, JsonpDeserializer.stringDeserializer(), "last_modified", new String[0]);
        op.add(Builder::pipelineMetadata, PipelineMetadata._DESERIALIZER, "pipeline_metadata", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline", new String[0]);
        op.add(Builder::pipelineSettings, PipelineSettings._DESERIALIZER, "pipeline_settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Pipeline> {
        private String description;
        private String lastModified;
        private PipelineMetadata pipelineMetadata;
        private String username;
        private String pipeline;
        private PipelineSettings pipelineSettings;

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder lastModified(String value) {
            this.lastModified = value;
            return this;
        }

        public Builder pipelineMetadata(PipelineMetadata value) {
            this.pipelineMetadata = value;
            return this;
        }

        public Builder pipelineMetadata(Function<PipelineMetadata.Builder, ObjectBuilder<PipelineMetadata>> fn) {
            return this.pipelineMetadata(fn.apply(new PipelineMetadata.Builder()).build());
        }

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        public Builder pipeline(String value) {
            this.pipeline = value;
            return this;
        }

        public Builder pipelineSettings(PipelineSettings value) {
            this.pipelineSettings = value;
            return this;
        }

        public Builder pipelineSettings(Function<PipelineSettings.Builder, ObjectBuilder<PipelineSettings>> fn) {
            return this.pipelineSettings(fn.apply(new PipelineSettings.Builder()).build());
        }

        @Override
        public Pipeline build() {
            return new Pipeline(this);
        }
    }
}

