/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisClassification;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisOutlierDetection;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisRegression;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalysis
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String CLASSIFICATION = "classification";
    public static final String OUTLIER_DETECTION = "outlier_detection";
    public static final String REGRESSION = "regression";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<DataframeAnalysis> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, DataframeAnalysis::setupDataframeAnalysisDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public DataframeAnalysis(DataframeAnalysisVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private DataframeAnalysis(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public DataframeAnalysis(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public DataframeAnalysisClassification classification() {
        return (DataframeAnalysisClassification)TaggedUnionUtils.get(this, CLASSIFICATION);
    }

    public DataframeAnalysisOutlierDetection outlierDetection() {
        return (DataframeAnalysisOutlierDetection)TaggedUnionUtils.get(this, OUTLIER_DETECTION);
    }

    public DataframeAnalysisRegression regression() {
        return (DataframeAnalysisRegression)TaggedUnionUtils.get(this, REGRESSION);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDataframeAnalysisDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classification, DataframeAnalysisClassification._DESERIALIZER, CLASSIFICATION, new String[0]);
        op.add(Builder::outlierDetection, DataframeAnalysisOutlierDetection._DESERIALIZER, OUTLIER_DETECTION, new String[0]);
        op.add(Builder::regression, DataframeAnalysisRegression._DESERIALIZER, REGRESSION, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalysis> {
        private String _type;
        private Object _value;

        public Builder classification(DataframeAnalysisClassification v) {
            this._type = DataframeAnalysis.CLASSIFICATION;
            this._value = v;
            return this;
        }

        public Builder classification(Function<DataframeAnalysisClassification.Builder, ObjectBuilder<DataframeAnalysisClassification>> f) {
            return this.classification(f.apply(new DataframeAnalysisClassification.Builder()).build());
        }

        public Builder outlierDetection(DataframeAnalysisOutlierDetection v) {
            this._type = DataframeAnalysis.OUTLIER_DETECTION;
            this._value = v;
            return this;
        }

        public Builder outlierDetection(Function<DataframeAnalysisOutlierDetection.Builder, ObjectBuilder<DataframeAnalysisOutlierDetection>> f) {
            return this.outlierDetection(f.apply(new DataframeAnalysisOutlierDetection.Builder()).build());
        }

        public Builder regression(DataframeAnalysisRegression v) {
            this._type = DataframeAnalysis.REGRESSION;
            this._value = v;
            return this;
        }

        public Builder regression(Function<DataframeAnalysisRegression.Builder, ObjectBuilder<DataframeAnalysisRegression>> f) {
            return this.regression(f.apply(new DataframeAnalysisRegression.Builder()).build());
        }

        @Override
        public DataframeAnalysis build() {
            return new DataframeAnalysis(this);
        }
    }
}

