/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteDataFrameAnalyticsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteDataFrameAnalyticsRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final Boolean force;
    @Nullable
    private final String timeout;
    public static final Endpoint<DeleteDataFrameAnalyticsRequest, DeleteDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteDataFrameAnalyticsRequest, DeleteDataFrameAnalyticsResponse>(request -> "DELETE", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteDataFrameAnalyticsResponse._DESERIALIZER);

    public DeleteDataFrameAnalyticsRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.force = builder.force;
        this.timeout = builder.timeout;
    }

    public DeleteDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteDataFrameAnalyticsRequest> {
        private String id;
        @Nullable
        private Boolean force;
        @Nullable
        private String timeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteDataFrameAnalyticsRequest build() {
            return new DeleteDataFrameAnalyticsRequest(this);
        }
    }
}

