/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FlushJobResponse
implements JsonpSerializable {
    private final boolean flushed;
    @Nullable
    private final Integer lastFinalizedBucketEnd;
    public static final JsonpDeserializer<FlushJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlushJobResponse::setupFlushJobResponseDeserializer, Builder::build);

    public FlushJobResponse(Builder builder) {
        this.flushed = Objects.requireNonNull(builder.flushed, "flushed");
        this.lastFinalizedBucketEnd = builder.lastFinalizedBucketEnd;
    }

    public FlushJobResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean flushed() {
        return this.flushed;
    }

    @Nullable
    public Integer lastFinalizedBucketEnd() {
        return this.lastFinalizedBucketEnd;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("flushed");
        generator.write(this.flushed);
        if (this.lastFinalizedBucketEnd != null) {
            generator.writeKey("last_finalized_bucket_end");
            generator.write(this.lastFinalizedBucketEnd.intValue());
        }
    }

    protected static void setupFlushJobResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::flushed, JsonpDeserializer.booleanDeserializer(), "flushed", new String[0]);
        op.add(Builder::lastFinalizedBucketEnd, JsonpDeserializer.integerDeserializer(), "last_finalized_bucket_end", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FlushJobResponse> {
        private Boolean flushed;
        @Nullable
        private Integer lastFinalizedBucketEnd;

        public Builder flushed(boolean value) {
            this.flushed = value;
            return this;
        }

        public Builder lastFinalizedBucketEnd(@Nullable Integer value) {
            this.lastFinalizedBucketEnd = value;
            return this;
        }

        @Override
        public FlushJobResponse build() {
            return new FlushJobResponse(this);
        }
    }
}

